/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
*/
#define DB(x)

#include <glib/gprintf.h>
#include <math.h>

#include "config.h"

#include "gsi.h"
#include "ww_data.h"
#include "ww_object.h"
#include "ww_nmap.h"
#include "ww_layerset.h"
#include "util.h"
#include "camera.h"
#include "color.h"
#include "nmapdata.h"

typedef struct _WwNmapPrivate WwNmapPrivate;
struct _WwNmapPrivate {
	gboolean dispose_has_run;

	/*****/

	gdouble max_alt;

	gdouble north;
	gdouble south;
	gdouble west;
	gdouble east;
};

#define WW_NMAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), WW_TYPE_NMAP, WwNmapPrivate))

static WwObjectClass *parent_class = NULL;

static void ww_nmap_class_init (WwNmapClass * klass);
static void ww_nmap_init (WwNmap * object);
static void ww_nmap_dispose (GObject * object);
static void ww_nmap_finalize (GObject * object);
static GObject *ww_nmap_constructor (GType type, guint n_props, GObjectConstructParam * props);
static void ww_nmap_interface_init (gpointer g_iface, gpointer iface_data);

/*****************************************************************************/

static void ww_nmap_set_attribute (WwData * data, const gchar ** name, const gchar ** value);
static void ww_nmap_set_element (WwData * data, const gchar * element0, const gchar * element1, const gchar * value);
static void ww_nmap_set_parent (WwData * data, WwData * parent);
static void ww_nmap_set_child (WwData * data, WwData * child);

static void ww_nmap_update (WwObject * self);
static void ww_nmap_render (WwObject * self);
static void ww_nmap_set_on (WwObject * self, gboolean);
static void ww_nmap_debug_print (WwObject * self);

/*****************************************************************************/

GType
ww_nmap_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (WwNmapClass),
			NULL,				/* base_init */
			NULL,				/* base_finalize */
			(GClassInitFunc) ww_nmap_class_init,
			NULL,				/* class_finalize */
			NULL,				/* class_data */
			sizeof (WwNmap),
			0,					/* n_preallocs */
			(GInstanceInitFunc) ww_nmap_init
		};

		static const GInterfaceInfo ww_data_info = {
			(GInterfaceInitFunc) ww_nmap_interface_init,	/* interface_init */
			NULL,				/* interface_finalize */
			NULL				/* interface_data */
		};

		type = g_type_register_static (WW_TYPE_OBJECT, "WwNmap", &info, 0);

		g_type_add_interface_static (type, WW_TYPE_DATA, &ww_data_info);
	}

	return type;
}

static void
ww_nmap_class_init (WwNmapClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	WwObjectClass *wwobject_class = WW_OBJECT_CLASS (klass);
	/*
	   g_print ("ww_nmap_class_init:c:%p:\n", klass);
	 */
	g_type_class_add_private (klass, sizeof (WwNmapPrivate));

	parent_class = g_type_class_peek_parent (klass);
	object_class->constructor = ww_nmap_constructor;
	object_class->dispose = ww_nmap_dispose;
	object_class->finalize = ww_nmap_finalize;

	wwobject_class->update = ww_nmap_update;
	wwobject_class->render = ww_nmap_render;
	wwobject_class->set_on = ww_nmap_set_on;
	wwobject_class->debug_print = ww_nmap_debug_print;
}

static void
ww_nmap_init (WwNmap * self)
{
	WwNmapPrivate *priv = WW_NMAP_GET_PRIVATE (self);
	/*
	   g_print ("ww_nmap_init:o:%p:\n", self);
	 */
	priv->dispose_has_run = FALSE;
	priv->max_alt = 15000;
	priv->north = 45.0 + 33.0 / 60.0;
	priv->south = 20.0 + 25.0 / 60.0;
	priv->west = 122.0 + 56.0 / 60.0;
	priv->east = 153.0 + 59.0 / 60.0;
}

static void
ww_nmap_dispose (GObject * obj)
{
	WwNmap *self = WW_NMAP (obj);
	WwNmapPrivate *priv = WW_NMAP_GET_PRIVATE (self);

	g_print ("ww_nmap_dispose\n");

	if (priv->dispose_has_run) {
		return;
	}
	priv->dispose_has_run = TRUE;

	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void
ww_nmap_finalize (GObject * obj)
{
	/*
	WwNmap *self = WW_NMAP (obj);
	WwNmapPrivate *priv = WW_NMAP_GET_PRIVATE (self);
	g_print ("finalize\n");
	 */

	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static GObject *
ww_nmap_constructor (GType type, guint n_props, GObjectConstructParam * props)
{
	GObject *object;
	GObjectClass *object_class = G_OBJECT_CLASS (parent_class);
	/*
	   g_print ("constructor\n");
	 */
	object = object_class->constructor (type, n_props, props);

	return object;
}

static void
ww_nmap_interface_init (gpointer g_iface, gpointer iface_data)
{
	WwDataInterface *iface = (WwDataInterface *) g_iface;

	iface->set_attribute = ww_nmap_set_attribute;
	iface->set_element = ww_nmap_set_element;
	iface->set_parent = ww_nmap_set_parent;
	iface->set_child = ww_nmap_set_child;
}

WwObject *
ww_nmap_new (void)
{
	GObject *object;

	object = g_object_new (WW_TYPE_NMAP, NULL);
	/*
	   g_print ("ww_nmap_new:o:%p\n", object);
	 */
	return WW_OBJECT (object);
}

/********************************************************************/

static void
ww_nmap_update (WwObject * self)
{
	WwNmap *nmap;
	WwNmapPrivate *priv;
	gdouble lon, lat, alt;

	if (self == NULL) {
		return;
	}

	lon = camera_get_lon ();
	lat = camera_get_lat ();
	alt = camera_get_dist_target ();

	nmap = WW_NMAP (self);
	priv = WW_NMAP_GET_PRIVATE (nmap);

	if (self->is_on == TRUE) {
        /*
        g_print ("ww_nmap_update:%s\n", self->name);
        */

	    if (priv->max_alt > alt && camera_check_overlap (priv->north, priv->south, priv->west, priv->east) == TRUE) {
	        gdouble x0, y0, x1, y1;

            camera_get_view_narrow (&x0, &y0, &x1, &y1);
            citylist_update(x0, y0, x1, y1);
	    }else{

            citylist_clear();
        }

    }else{
        citylist_clear();
    }
}

static void
ww_nmap_render (WwObject * self)
{
	WwNmapPrivate *priv = WW_NMAP_GET_PRIVATE (self);
    gdouble alt;

	alt = camera_get_dist_target ();

	if (self->is_on == FALSE || priv->max_alt < alt) {
		return;
	}

    /*
    g_print ("ww_nmap_render:%s\n", self->name);
    */

    citylist_render();
}

static void
ww_nmap_set_attribute (WwData * data, const gchar ** name, const gchar ** value)
{
	WwDataInterface *parent_wwdata_iface = g_type_interface_peek (parent_class, WW_TYPE_DATA);
	/*
	   g_print ("ww_nmap_set_attribute:o:%p\n", data);
	 */

	/* 専用の attribute はない */

	parent_wwdata_iface->set_attribute (data, name, value);
}

static void
ww_nmap_set_element (WwData * data, const gchar * element0, const gchar * element1, const gchar * value)
{
	WwDataInterface *parent_wwdata_iface = g_type_interface_peek (parent_class, WW_TYPE_DATA);
	/*
	   g_print ("ww_nmap_set_element:o:%p e0:%s e1:%s value:%s\n", data, element0, element1, value);
	 */

	/* 独自の element なし */

	parent_wwdata_iface->set_element (data, element0, element1, value);
}

static void
ww_nmap_set_parent (WwData * data, WwData * parent)
{
	WwDataInterface *parent_wwdata_iface = g_type_interface_peek (parent_class, WW_TYPE_DATA);

	/* 親のままでいい */
	parent_wwdata_iface->set_parent (data, parent);
}

static void
ww_nmap_set_child (WwData * data, WwData * child)
{
	/* なにもしない */
}

static void
ww_nmap_set_on (WwObject * obj, gboolean is_on)
{
	WwObject *obj_parent = obj->wwparent;

	if (is_on == TRUE && WW_IS_LAYERSET (obj_parent)) {
		/* is_on == TRUE の時のみでないと、ループする */
		ww_layerset_check_show_only_one_layer (WW_LAYERSET (obj_parent));
	}

	parent_class->set_on (obj, is_on);
}

static void
ww_nmap_debug_print (WwObject * obj)
{
	WwNmapPrivate *priv = WW_NMAP_GET_PRIVATE (obj);

	g_print ("ww_nmap_debug_print##########:o:%p\n", obj);

	parent_class->debug_print (obj);

	g_print ("\t north:%.2f\n", priv->north);
	g_print ("\t south:%.2f\n", priv->south);
	g_print ("\t west:%.2f\n", priv->west);
	g_print ("\t east:%.2f\n", priv->east);
}

