/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


/*
#define DB(x) (x)
*/
#define DB(x)

#include <GL/gl.h>

#include "config.h"

#include "mmap.h"
#include "ww_meshst.h"
#include "mesh.h"

typedef struct _WwMeshstPrivate WwMeshstPrivate;
struct _WwMeshstPrivate {
	gboolean dispose_has_run;

	gint nx;					/* 分割数 */
	gint ny;

	gdouble *t_st;
};

#define WW_MESHST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), WW_TYPE_MESHST, WwMeshstPrivate))

static GObjectClass *parent_class = NULL;

static void ww_meshst_class_init (WwMeshstClass * klass);
static void ww_meshst_init (WwMeshst * object);
static void ww_meshst_finalize (GObject * object);
static void ww_meshst_dispose (GObject * object);
static GObject *ww_meshst_constructor (GType type, guint n_props, GObjectConstructParam * props);

/*****************************************************************************/

GType
ww_meshst_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (WwMeshstClass),
			NULL,				/* base_init */
			NULL,				/* base_finalize */
			(GClassInitFunc) ww_meshst_class_init,
			NULL,				/* class_finalize */
			NULL,				/* class_data */
			sizeof (WwMeshst),
			0,					/* n_preallocs */
			(GInstanceInitFunc) ww_meshst_init
		};

		type = g_type_register_static (G_TYPE_OBJECT, "WwMeshst", &info, 0);
	}

	return type;
}

static void
ww_meshst_class_init (WwMeshstClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	/*
	   g_print ("ww_meshst_class_init:c:%p:\n", klass);
	 */
	g_type_class_add_private (klass, sizeof (WwMeshstPrivate));

	parent_class = g_type_class_peek_parent (klass);
	object_class->constructor = ww_meshst_constructor;
	object_class->finalize = ww_meshst_finalize;
	object_class->dispose = ww_meshst_dispose;
}

static void
ww_meshst_init (WwMeshst * self)
{
	WwMeshstPrivate *priv = WW_MESHST_GET_PRIVATE (self);

	/*
	   g_print ("ww_meshst_init:o:%p:\n", self);
	 */

	priv->dispose_has_run = FALSE;
	priv->nx = 0;
	priv->ny = 0;
	priv->t_st = NULL;
}

static void
ww_meshst_dispose (GObject * obj)
{
	WwMeshst *self = WW_MESHST (obj);
	WwMeshstPrivate *priv = WW_MESHST_GET_PRIVATE (self);
	/*
	   g_print ("ww_meshst_dispose\n");
	 */
	if (priv->dispose_has_run) {
		return;
	}
	priv->dispose_has_run = TRUE;

	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void
ww_meshst_finalize (GObject * obj)
{
	WwMeshst *self = WW_MESHST (obj);
	WwMeshstPrivate *priv = WW_MESHST_GET_PRIVATE (self);
	/*
	   g_print ("ww_meshst_finalize\n");
	 */
	g_free (priv->t_st);

	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static GObject *
ww_meshst_constructor (GType type, guint n_props, GObjectConstructParam * props)
{
	GObject *object;
	GObjectClass *object_class = G_OBJECT_CLASS (parent_class);
	/*
	   g_print ("ww_meshst_constructor\n");
	 */
	object = object_class->constructor (type, n_props, props);

	return object;
}

WwMeshst *
ww_meshst_new (void)
{
	GObject *object;

	object = g_object_new (WW_TYPE_MESHST, NULL);
	/*
	   g_print ("ww_meshst_new:o:%p\n", object);
	 */
	return WW_MESHST (object);
}

/********************************************************************/

WwMeshst *
ww_meshst_new_simple (gint nx, gint ny)
{
	WwMeshst *st;
	WwMeshstPrivate *priv;
	/*
	   g_print ("ww_meshst_new_simple\n");
	 */
	st = ww_meshst_new ();
	priv = WW_MESHST_GET_PRIVATE (st);

	priv->nx = nx;
	priv->ny = ny;

	priv->t_st = mesh_create_st_simple (nx, ny);

	return st;
};

/* px0, py0, px1, py1 ::: テクスチャーの範囲（経度緯度）
 * cx0, cy0, cx1, cy1 ::: そのテクスチャー内で利用する範囲（経度緯度） */
WwMeshst *
ww_meshst_new_complex (gint nx, gint ny, gdouble px0, gdouble py0, gdouble px1, gdouble py1,
					   gdouble cx0, gdouble cy0, gdouble cx1, gdouble cy1)
{
	WwMeshst *st;
	WwMeshstPrivate *priv;
	/*
	   g_print ("ww_meshst_new_complex\n");
	 */
	st = ww_meshst_new ();
	priv = WW_MESHST_GET_PRIVATE (st);

	priv->nx = nx;
	priv->ny = ny;

	priv->t_st = mesh_create_st (px0, py0, px1, py1, cx0, cy0, cx1, cy1, nx, ny);

	return st;
};

void
ww_meshst_change_simple (WwMeshst * st)
{
	WwMeshstPrivate *priv;

	if (st == NULL) {
		return;
	}

	priv = WW_MESHST_GET_PRIVATE (st);

	g_free (priv->t_st);

	priv->t_st = mesh_create_st_simple (priv->nx, priv->ny);
}

void
ww_meshst_bind (WwMeshst * st)
{
	WwMeshstPrivate *priv;

	if (st == NULL) {
		return;
	}

	priv = WW_MESHST_GET_PRIVATE (st);

	glTexCoordPointer (2, GL_DOUBLE, 0, priv->t_st);
}
