/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_GSILOADER_H__
#define __WW_GSILOADER_H__

#include <gtk/gtk.h>

#include "nmapdata.h"

G_BEGIN_DECLS

#define WW_TYPE_GSILOADER                (ww_gsiloader_get_type ())
#define WW_GSILOADER(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_GSILOADER, WwGsiloader))
#define WW_GSILOADER_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_GSILOADER, WwGsiloaderClass))
#define WW_IS_GSILOADER(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_GSILOADER))
#define WW_IS_GSILOADER_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_GSILOADER))
#define WW_GSILOADER_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_GSILOADER, WwGsiloaderClass))

typedef struct _WwGsiloader WwGsiloader;
typedef struct _WwGsiloaderClass WwGsiloaderClass;

struct _WwGsiloader {
	GObject parent;
};

struct _WwGsiloaderClass {
	GObjectClass parent_class;
};

GType ww_gsiloader_get_type (void);

WwGsiloader *ww_gsiloader_new (void);
void ww_gsiloader_set_owner (WwGsiloader * loader, GObject *owner);
void ww_gsiloader_add_source (WwGsiloader * loader, struct _NCity *city);
void ww_gsiloader_add_source_list (WwGsiloader * loader, GSList *sl_city);
void ww_gsiloader_start (WwGsiloader * loader);

G_END_DECLS

#endif /* __WW_GSILOADER_H__ */
