/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __GSI_H__
#define __GSI_H__

#include "data.h"

void gsi_keidoido_to_xyz (gdouble keido, gdouble ido, gdouble alt, gdouble * x, gdouble * y, gdouble * z);

/********************/

typedef struct {
	gchar id[3];
	gchar *name;
	gchar *value;
} Data25k;

const gchar *gsi25k_get_data (const gchar * text, Data25k * data25k);
void gsi25k_print_curve (const gchar * curve, Slp * slp, GIOChannel * ch_edge, GIOChannel * ch_node, gint multi);

#endif /* __GSI_H__ */
