/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __DATA_H__
#define __DATA_H__

typedef struct {
	gint n;						/* データ数 */
	gchar **v;					/* 国土地理院のインデックスは１から。MSMap では０から。 */
} Slp;

Slp *slp_create (const gchar * name, gint64 x0, gint64 y0, gint n);
void slp_free (Slp * slp);

/*******************/

void slm (const gchar * name, gint64 * x, gint64 * y, gint * n);

/*******************/

void edge_create (const gchar * name, Slp * slp, GIOChannel * ch_edge, GIOChannel * ch_node);

#endif  /* __DATA_H__ */
