/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
*/
#define DB(x)

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "text.h"

static GdkGC *gc;
static GdkDrawable *drawable_window;
static PangoContext *context;
static PangoLayout *layout;

void
text_init (GtkWidget * widget)
{
	PangoFontDescription *desc;
	/*
	g_print ("text_init\n");
	*/

	context = gtk_widget_get_pango_context (widget);
	/*
	context = pango_xft_get_context (gdk_x11_get_default_xdisplay (),
	gdk_x11_get_default_screen ());
	*/
	desc = pango_context_get_font_description (context);
	pango_font_description_set_size (desc, 10 * PANGO_SCALE);

	layout = pango_layout_new (context);

	drawable_window = GDK_DRAWABLE (widget->window);
	gc = gdk_gc_new (drawable_window);
}

static guchar *
reverse_pixels (guchar * pixels, gint w, gint h)
{
	guchar *ret;
	gint x, y;

	DB (g_print ("reverse_pixels:w:%d h:%d\n", w, h));

	ret = g_new (guchar, w * h * 4);
	for (y = 0; y < h; ++y) {
		for (x = 0; x < w; ++x) {
			guchar *src;
			guchar *dest;

			dest = ret + (w * y + x) * 4;
			src = pixels + (w * (h - y - 1) + x) * 4;

			dest[0] = 255 - src[0];
			dest[1] = 255 - src[1];
			dest[2] = 255 - src[2];
			/* アンチエイリアスがかかった場合、薄い黒を透明度とみなして使う */
			dest[3] = 255 - src[0];
		}
	}
	return ret;
}

PixText *
text_create (const gchar * text)
{
	PangoRectangle rect;
	GdkPixmap *pixmap;
	GdkPixbuf *pixbuf;
	GdkColormap *colormap;
	GdkColor c_black = { 0, 0, 0, 0 };
	GdkColor c_white = { 0, 65535, 65535, 65535 };
	PixText *pixtext;
	guchar *pixels;
	gint w, h;
	GdkDrawable *drawable;

	g_return_val_if_fail (text != NULL && *text != '\0', NULL);
	/*
	g_print("text_create:%s:\n", text);
	*/

	pango_layout_set_text (layout, text, -1);
	pango_layout_get_pixel_extents (layout, NULL, &rect);
	w = rect.width;
	h = rect.height;

	pixmap = gdk_pixmap_new (drawable_window, w, h, -1);
	drawable = GDK_DRAWABLE (pixmap);

	pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, w, h);
	gdk_draw_layout_with_colors (drawable, gc, 0, 0, layout, &c_black, &c_white);
	colormap = gdk_colormap_get_system ();
	gdk_pixbuf_get_from_drawable (pixbuf, drawable, colormap, 0, 0, 0, 0, w, h);
	g_object_unref (pixmap);
	/*
	gdk_pixbuf_save(pixbuf, "test2.png", "png", NULL); 
	*/
	pixels = gdk_pixbuf_get_pixels (pixbuf);

	pixtext = g_new (PixText, 1);
	pixtext->w = rect.width;
	pixtext->h = rect.height;
	pixtext->pix = reverse_pixels (pixels, w, h);
	/*
	memcpy(pixels, pixtext->pix, w*h*4);
	gdk_pixbuf_save(pixbuf, "test.png", "png", NULL); 
	g_print("text_create:w:%d h:%d r:%d\n", pixtext->w, pixtext->h, gdk_pixbuf_get_rowstride(pixbuf));
	*/
	g_object_unref (pixbuf);

	return pixtext;
}

void
text_free(PixText *pixtext)
{
    if(pixtext == NULL){
        return;
    }
	g_free (pixtext->pix);
	g_free (pixtext);
}
