/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* allnode.bin の中身はこれの配列
 * 配列は経度の小さい順にならんでいる。経度が同じなら緯度の小さい順にならぶ。
 * クリックした経度緯度から一番近いノードを探すのに使うデータ。 */
typedef struct {
	gfloat lon; /* 秒 */
	gfloat lat;
} AllNodeBin;


typedef struct {
	gfloat lon; /* sec */
	gfloat lat;
} LonLat;

/* edge_start_n.bin の中身：：：LonLat の配列の何番目から何個が１つのエッジかをあらわす */
typedef struct {
	gint start;
	gint n;
	gfloat l;					/* エッジの長さ */
} EdgeStartN;

/* node_start_n.bin の中身：：：Curve のインデックスの配列の何番目から何個が１つのノードにつながっているかをあらわす */
typedef struct {
	gint start;
	gint n;
} NodeStartN;

/* これの配列が検索に使うエッジデータそのもの */
/* allnodebin[node_index0] と allnodebin[node_index1] がエッジの両端のノードを表す */
typedef struct {
	gint node_index0;           
	gint node_index1;
	gfloat l;					/* エッジの長さ * 重み */
	/* カーブの距離：幅員 3.0m 以上の時、最大で 26394 */
	/* guint16 にしてたが、非常に近い距離にある３点が始点から同じ距離になる場合に、無限ループに入る
	 * ことがあるので、gfloat にもどす。無限ループになる可能性は残るが、大幅に減るのを期待 */
} Edge;

/* これの配列が検索に使うノードデータそのもの */
typedef struct {
	gint *edge_index;
	gint n;
	gfloat l;					/* スタート地点からの距離 (m) */
} Node;

/********************************************************/
