/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __NMAPDATA_H__
#define __NMAPDATA_H__


#include "nmapdata_all.h"

typedef enum {
	GK,
	SK,
	DK,
	TK,
	KK,
	KJ,
	KO,
	CM,
	TEXT,
    CITY_DATA_N
} NCityDataType;

typedef enum {
	TEXT_TK = 0xa0,
	/* TEXT_DK = 0xa1, */
	TEXT_KJ = 0xa2,
	TEXT_KO = 0xa3,
	TEXT_CM = 0xa4,
	TEXT_N = 0xa5,
} NCityTextType;

typedef struct {
	Slm *slm;
	/*
	Slp *slp;
	*/
	Gk *gk;
	Sk *sk;
	Dk *dk;
	Tk *tk;
	Kk *kk;
	Kj *kj;
	Ko *ko;
	Cm *cm;
} Data;

typedef struct _NCity NCity;

#include "ww_gsiloader.h"

struct _NCity{
	gchar *name;                /* 11111 */
	gchar *path;				/* pref/11111 */
	gdouble x0;					/* データのある範囲 */
	gdouble y0;
	gdouble x1;
	gdouble y1;
	gchar *city;

    GMutex *mutex_data;
    struct _WwGsiloader *loader;    /* Data *data 用 */
    Data *data;
    Mh *mh;
    gint mh_counter;
}; 

void citylist_init(void);
void citylist_free(void);
void citylist_render (void);
void citylist_update (gdouble x0, gdouble y0, gdouble x1, gdouble y1);
void citylist_clear(void);
GSList * citylist_lookup(gdouble x0, gdouble y0, gdouble x1, gdouble y1);

void city_change (NCityDataType datatype, gint num);

gdouble city_get_alt (gdouble lon, gdouble lat);
void city_create_mh (NCity *city);
void city_free_mh (NCity *city);
void city_create_other (NCity *city);

void nmapdata_selector_init (void);
void nmapdata_selector_show (void);
void nmapdata_selector_check_alt_up (gdouble alt_old, gdouble alt_new);
void nmapdata_selector_check_alt_down (gdouble alt_old, gdouble alt_new);

void nmapdata_selector_lock (void);
void nmapdata_selector_unlock (void);
gboolean nmapdata_selector_check_onoff(gint num);
gboolean nmapdata_selector_check_onoff_text(gint num);

#endif  /* __NMAPDATA_H__ */
