/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __MESH_H__
#define __MESH_H__

#include <gtk/gtk.h>

#include "ww_terrainaccessor.h"

gdouble *mesh_create_st (gdouble px0, gdouble py0, gdouble px1, gdouble py1, gdouble cx0, gdouble cy0, gdouble cx1, gdouble cy1,
						 gint nx, gint ny);
gdouble *mesh_create_st_simple (gint nx, gint ny);
gdouble *mesh_create_deg_copy (gdouble px0, gdouble py0, gdouble px1, gdouble py1,
							   gdouble cx0, gdouble cy0, gdouble cx1, gdouble cy1, gint nx, gint ny, gdouble * parent);
gdouble *mesh_create_deg (gdouble x0, gdouble y0, gdouble x1, gdouble y1, gint nx, gint ny, WwTerrainaccessor * ta);

gdouble *mesh_create_xyz (gdouble * v_deg, gint nx, gint ny, gdouble above_surface, gdouble multi);
void mesh_change_xyz (gdouble * v_deg, gdouble * v_xyz, gint nx, gint ny, gdouble above_surface, gdouble multi);
guint *mesh_create_index (gint nx, gint ny);

void mesh_mmap_init (void);
void mesh_mmap_gl_init (void);
guint *mesh_mmap_i_init (void);
guint mesh_mmap_index_buffer_name (void);
gdouble *mesh_mmap_t_st_init (void);
guint mesh_mmap_t_st_buffer_name (void);
gdouble *mesh_mmap_v_deg_init (gdouble x, gdouble y, gint nx, gint ny);
gdouble *mesh_mmap_v_xyz_init (gdouble * v_deg, gint nx, gint ny, gdouble multi);
void mesh_mmap_v_xyz_change (gdouble * v_deg, gdouble * v_xyz, gint nx, gint ny, gdouble multi);
gdouble *mesh_mmap_n_init (gdouble * v_xyz, gint nx, gint ny);
gdouble *mesh_mmap_c_init (gint nx, gint ny);
void mesh_mmap_c_calc (gdouble * c, gdouble * v_deg, gint nv);

#endif /* __MESH_H__ */
