/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
*/
#define DB(x)

#include <stdlib.h>
#include <string.h>

#include "gsi.h"

/*****************************************************************/

/*
 * データの基本形は３つ。
 * (1) AA(名前){中身}     名前付きデータで他から参照できる
 * (2) AA{中身}           名前なしデータ
 * (3) AA(名前)           他のデータへの参照
 *
 * 名前も中身もデータで、名前は(2)のデータを１つだけ持ち、中身は(1)(2)(3)のデータ
 * を複数持つ。名前には以下の２種類がある。
 * ・ID{AA****}     (1) の名前として使われる
 * ・IR{AA****}     (3) の名前として使われる
 *
 * データは１件１行で書かれている。
 */

/* { か ( を指すアドレスをもらって、その括弧に対応する閉じ括弧までの文字列を data にいれて返す。
 * 返り値は閉じ括弧の次のアドレスを返す。 */
static const gchar *
get_char (const gchar * text, gchar ** data)
{
	gchar kakko;
	gchar *p;
	gint nest = 0;
	/*
	   DB(g_print("get_char:%s:\n",text));
	 */
	if (text[0] == '(') {
		kakko = ')';
	} else if (text[0] == '{') {
		kakko = '}';
	} else {
		DB (g_print ("err:get_char:%s:\n", text));
		exit (1);
	}

	p = (gchar *) (text + 1);
	while (*p != '\0') {
		{
			guint8 c;

			c = (guint8) (*p);

			/* 次の文字が SJIS の２バイト文字ならスキップ */
			if ((c >= 0x81 && c <= 0x9f) || (c >= 0xe0 && c <= 0xfc)) {
				p += 2;
				continue;
			}
		}

		if (*p == text[0]) {
			++nest;
		} else if (*p == kakko) {
			if (nest == 0) {
				gint n;

				n = p - text - 1;
				*data = g_strndup (text + 1, n);

				return p + 1;
			} else {
				--nest;
			}
		}
		++p;
	}

	return p;
}

/* text はデータの先頭アドレスを指し、終端が '\0' である必要がある。返り値は次のデータの先頭アドレス。*/
const gchar *
gsi25k_get_data (const gchar * text, Data25k * data25k)
{
	gchar *name;
	gchar *value;
	const gchar *next;

	DB (g_print ("gsi25k_get_data:%s\n", text));

	data25k->id[0] = text[0];
	data25k->id[1] = text[1];
	data25k->id[2] = '\0';

	if (text[2] == '{') {
		DB (g_print ("without_name\n"));
		name = NULL;
		next = get_char (&(text[2]), &value);

	} else if (text[2] == '(' && text[4] == 'D') {
		DB (g_print ("with_name\n"));
		next = get_char (&(text[2]), &name);
		next = get_char (next, &value);

	} else if (text[2] == '(' && text[4] == 'R') {
		DB (g_print ("ref\n"));
		next = get_char (&(text[2]), &name);
		value = NULL;

	} else {
		g_print ("err:gsi25k_get_data:%s:\n", text);

		exit (1);
	}

	data25k->name = name;
	data25k->value = value;

	DB (g_print ("data25k_get_data:id   :%s:\n", data25k->id));
	DB (g_print ("data25k_get_data:name :%s:\n", data25k->name));
	DB (g_print ("data25k_get_data:value:%s:\n", data25k->value));

	return next;
}

/********************************************************/

/* インデックスのカンマ区切りの文字列を受けとり、座標の配列を作って返す。 */
gfloat *
gsi25k_get_curve (const gchar * data, Slp * slp, gint * return_n)
{
	gint n = 0;
	gint i;
	gfloat *v;
	const gchar *p;

	/* 数える。data は ６桁の数字のカンマ区切りで終端 '\0' */
	n = (strlen (data) + 1) / 7;
	DB (g_print ("get_curve:n:%d:\n", n));

	v = g_new (gfloat, n * 3);

	for (i = 0, p = data; i < n; ++i, p += 7) {
		gint index = 0;
		gint tmp0;
		gint tmp1;

		index += (p[0] - '0') * 100000;
		index += (p[1] - '0') * 10000;
		index += (p[2] - '0') * 1000;
		index += (p[3] - '0') * 100;
		index += (p[4] - '0') * 10;
		index += (p[5] - '0') * 1;
		DB (g_print ("%d:%d\n", i, index));

		--index;				/* 国土地理院のインデックスは１から、MSMap は０から */

		tmp0 = i * 3;
		tmp1 = index * 3;

		*(v + tmp0 + 0) = slp->v[tmp1 + 0];
		*(v + tmp0 + 1) = slp->v[tmp1 + 1];
		*(v + tmp0 + 2) = slp->v[tmp1 + 2];
	}

	*return_n = n;
	return v;
}

/********************************************/

static guint8
hex_to_int (gchar a)
{
	guint8 n = 0;

	if (a >= '0' && a <= '9') {
		n = (a - '0');
	} else if (a >= 'A' && a <= 'F') {
		n = (a - 'A') + 10;
	}

	return n;
}

/* ２文字かつ大文字の１６進数を整数に変換する */
guint8
gsi25k_hex_to_int (const gchar * text)
{
	guint8 n = 0;

	n += hex_to_int (text[0]) * 16;
	n += hex_to_int (text[1]);
	/*
	   g_print("gsi25k_hex_to_int:%s:%d\n",text, n);
	 */
	return n;
}

gboolean
gsi25k_compare_id(Data25k *data25k, gchar id[])
{
    if (data25k->id[0] == id[0] && data25k->id[1] == id[1]) {
        return TRUE;
    }else{
        return FALSE;
    }
}
