#include "stdafx.h"

#include "NameAcceptor.h"

class __declspec(uuid("{91D98CD4-D832-4397-98AE-8B638BCA3818}")) CPatternNameAcceptor
	: public INameAcceptor
	, public CComObjectRoot
{
public:
	BEGIN_COM_MAP(CPatternNameAcceptor)
		COM_INTERFACE_ENTRY(INameAcceptor)
	END_COM_MAP( )

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT Init(LPCWSTR v_pPattern) throw()
	{
		if ( !v_pPattern) {
			v_pPattern = L"";
		}

		try {
			pattern_ = v_pPattern;
			ATLASSERT(pattern_.m_str);
		}
		catch (...) {
			return E_OUTOFMEMORY;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall IsAcceptable(LPCWSTR v_pName) throw()
	{
		if ( !v_pName) {
			v_pName = L"";
		}

		try {
			return IsMatch(v_pName, pattern_);
		}
		catch (...) {
			return E_FAIL;
		}
	}

protected:

	CComBSTR pattern_;
};

HRESULT __stdcall CreatePatternNameAcceptor(LPCWSTR v_pNamePattern, INameAcceptor** v_ppAcceptor) throw()
{
	if ( !v_ppAcceptor) {
		return E_POINTER;
	}

	HRESULT hr;
	
	CComObject<CPatternNameAcceptor> *pPatternNameAcceptorImpl = NULL;
	hr = CComObject<CPatternNameAcceptor>::CreateInstance(&pPatternNameAcceptorImpl);
	if (FAILED(hr)) {
		return hr;
	}
	CComPtr<INameAcceptor> pPatternNameAcceptor(pPatternNameAcceptorImpl);

	hr = pPatternNameAcceptorImpl->Init(v_pNamePattern);
	if (FAILED(hr)) {
		return hr;
	}

	return pPatternNameAcceptor.CopyTo(v_ppAcceptor);
}

