#include "stdafx.h"
#include "resource.h"

#include "Setting.h"

class __declspec(uuid("{77660F33-A60C-430e-9627-E5CE6D09BB1A}")) CSetting
	: public ISetting
	, public IPersistConf
	, public CComObjectRoot
	, public CComCoClass<CSetting, &__uuidof(CSetting)>
{
public:
	DECLARE_OBJECT_DESCRIPTION("MkImgPage Setting Object")

	BEGIN_COM_MAP(CSetting)
		COM_INTERFACE_ENTRY(ISettingReader)
		COM_INTERFACE_ENTRY(ISetting)
		COM_INTERFACE_ENTRY(IPersistConf)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()
	
	HRESULT FinalConstruct() throw()
	{
		return InitNew();
	}

	virtual HRESULT __stdcall InitNew(void) throw()
	{
		try {
			ImgLink_ = TRUE;
			ImgLinkExt_.LoadString(IDS_INIT_IMG_LINK_EXT);

			Img_ = TRUE;
			ImgExt_.LoadString(IDS_INIT_IMG_EXT);

			ImgSize_ = TRUE;
			ImgWidth_ = 200;
			ImgHeight_ = 200;

			UrlLink_ = TRUE;
			UrlLinkExt_.LoadString(IDS_INIT_URL_LINK_EXT);

			FrameWidth_ = 600;
			FrameHeight_ = 200;

			Link_ = TRUE;
			LinkExt_.LoadString(IDS_INIT_LINK_EXT);

			Embedded_ = TRUE;
			EmbeddedExt_.LoadString(IDS_INIT_EMBEDDED_EXT);

			Url_ = FALSE;
			UrlLimit_.Empty();

			OpenNew_ = FALSE;

			dirty_ = FALSE;

			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	virtual HRESULT __stdcall Load(IConfStrage* v_pConfStrage) throw()
	{
		if ( !v_pConfStrage) {
			return E_INVALIDARG;
		}

		try {
			CComBSTR tmp;

			CHK(InitNew());

			CHK(v_pConfStrage->GetDWORD(L"ImgLink", ImgLink_, &ImgLink_));
			
			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"ImgLinkExt", ImgLinkExt_, &tmp));
			ImgLinkExt_ = tmp;

			CHK(v_pConfStrage->GetDWORD(L"Img", Img_, &Img_));
			
			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"ImgExt", ImgExt_, &tmp));
			ImgExt_ = tmp;

			CHK(v_pConfStrage->GetDWORD(L"ImgSize", ImgSize_, &ImgSize_));
			CHK(v_pConfStrage->GetDWORD(L"ImgWidth", ImgWidth_, &ImgWidth_));
			CHK(v_pConfStrage->GetDWORD(L"ImgHeight", ImgHeight_, &ImgHeight_));
			CHK(v_pConfStrage->GetDWORD(L"UrlLink", UrlLink_, &UrlLink_));
			
			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"UrlLinkExt", UrlLinkExt_, &tmp));
			UrlLinkExt_ = tmp;

			CHK(v_pConfStrage->GetDWORD(L"FrameWidth", FrameWidth_, &FrameWidth_));
			CHK(v_pConfStrage->GetDWORD(L"FrameHeight", FrameHeight_, &FrameHeight_));
			CHK(v_pConfStrage->GetDWORD(L"Link", Link_, &Link_));
			
			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"LinkExt", LinkExt_, &tmp));
			LinkExt_ = tmp;

			CHK(v_pConfStrage->GetDWORD(L"Embedded", Embedded_, &Embedded_));
			
			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"EmbeddedExt", EmbeddedExt_, &tmp));
			EmbeddedExt_ = tmp;

			CHK(v_pConfStrage->GetDWORD(L"URL", Url_, &Url_));
			// v_pConfStrage->WriteString(L"URLLimit", URLLimit);

			CHK(v_pConfStrage->GetDWORD(L"OpenNew", OpenNew_, &OpenNew_));

			dirty_ = FALSE;

			return S_OK;
		}
		catch (const CAtlException& e) {
			return (HRESULT) e;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	virtual HRESULT __stdcall Save(IConfStrage* v_pConfStrage) throw()
	{
		if ( !v_pConfStrage) {
			return E_INVALIDARG;
		}

		try {
			CHK(v_pConfStrage->WriteDWORD(L"ImgLink", ImgLink_));
			CHK(v_pConfStrage->WriteString(L"ImgLinkExt", ImgLinkExt_));

			CHK(v_pConfStrage->WriteDWORD(L"Img", Img_));
			CHK(v_pConfStrage->WriteString(L"ImgExt", ImgExt_));

			CHK(v_pConfStrage->WriteDWORD(L"ImgSize", ImgSize_));
			CHK(v_pConfStrage->WriteDWORD(L"ImgWidth", ImgWidth_));
			CHK(v_pConfStrage->WriteDWORD(L"ImgHeight", ImgHeight_));

			CHK(v_pConfStrage->WriteDWORD(L"UrlLink", UrlLink_));
			CHK(v_pConfStrage->WriteString(L"UrlLinkExt", UrlLinkExt_));

			CHK(v_pConfStrage->WriteDWORD(L"FrameWidth", FrameWidth_));
			CHK(v_pConfStrage->WriteDWORD(L"FrameHeight", FrameHeight_));

			CHK(v_pConfStrage->WriteDWORD(L"Link", Link_));
			CHK(v_pConfStrage->WriteString(L"LinkExt", LinkExt_));

			CHK(v_pConfStrage->WriteDWORD(L"Embedded", Embedded_));
			CHK(v_pConfStrage->WriteString(L"EmbeddedExt", EmbeddedExt_));

			CHK(v_pConfStrage->WriteDWORD(L"URL", Url_));
			// v_pConfStrage->WriteString(L"URLLimit", URLLimit);

			CHK(v_pConfStrage->WriteDWORD(L"OpenNew", OpenNew_));

			dirty_ = FALSE;

			return S_OK;
		}
		catch (const CAtlException& e) {
			return (HRESULT) e;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	virtual HRESULT __stdcall IsDirty(void) throw()
	{
		return dirty_ ? S_OK: S_FALSE;
	}

	//

	/**
	 * 摜ւ̃NIMGɕϊ܂
	 */
	virtual HRESULT __stdcall put_ImgLink(BOOL v_value) throw()
	{
		ImgLink_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜ւ̃NIMGɕϊ܂B
	 */
	virtual HRESULT __stdcall is_ImgLink(void) throw()
	{
		return ImgLink_ ? S_OK : S_FALSE;
	}

	/**
	 * 摜ւ̃NIMGɕϊtB^
	 */
	virtual HRESULT __stdcall put_ImgLink_Ext(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			ImgLinkExt_ = v_value;
			dirty_ = TRUE;
			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * 摜ւ̃NIMGɕϊtB^
	 */
	virtual HRESULT __stdcall get_ImgLink_Ext(BSTR* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		return ImgLinkExt_.CopyTo(v_pValue);
	}

	/**
	 * 摜IMGɕϊ܂B
	 */
	virtual HRESULT __stdcall put_Img(BOOL v_value) throw()
	{
		Img_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊ܂B
	 */
	virtual HRESULT __stdcall is_Img(void) throw()
	{
		return Img_ ? S_OK : S_FALSE;
	}

	/**
	 * 摜IMGɕϊtB^B
	 */
	virtual HRESULT __stdcall put_Img_Ext(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			ImgExt_ = v_value;
			dirty_ = TRUE;
			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * 摜IMGɕϊtB^B
	 */
	virtual HRESULT __stdcall get_Img_Ext(BSTR* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		return ImgExt_.CopyTo(v_pValue);
	}

	/**
	 * 摜IMGɕϊTCY
	 */
	virtual HRESULT __stdcall put_Img_Size(BOOL v_value) throw()
	{
		ImgSize_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊTCY
	 */
	virtual HRESULT __stdcall is_Img_Size(void) throw()
	{
		return ImgSize_ ? S_OK : S_FALSE;
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall put_Img_Width(UINT v_value) throw()
	{
		ImgWidth_ = v_value;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall get_Img_Width(UINT* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		*v_pValue = ImgWidth_;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall put_Img_Height(UINT v_value) throw()
	{
		ImgHeight_ = v_value;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall get_Img_Height(UINT* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		*v_pValue = ImgHeight_;
		return S_OK;
	}

	/**
	 * URLIMGɕϊTCY
	 */
	virtual HRESULT __stdcall put_URLLink(BOOL v_value) throw()
	{
		UrlLink_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * URLIFRAMEɕϊ܂B
	 */
	virtual HRESULT __stdcall is_URLLink(void) throw()
	{
		return UrlLink_ ? S_OK : S_FALSE;
	}

	/**
	 * URLIFRAMEɕϊtB^B
	 */
	virtual HRESULT __stdcall put_URLLink_Ext(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			UrlLinkExt_ = v_value;
			dirty_ = TRUE;
			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * URLIFRAMEɕϊtB^B
	 */
	virtual HRESULT __stdcall get_URLLink_Ext(BSTR* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		return UrlLinkExt_.CopyTo(v_pValue);
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall put_IFrame_Width(UINT v_value) throw()
	{
		FrameWidth_ = v_value;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall get_IFrame_Width(UINT* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		*v_pValue = FrameWidth_;
		return S_OK;
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall put_IFrame_Height(UINT v_value) throw()
	{
		FrameHeight_ = v_value;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall get_IFrame_Height(UINT* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		*v_pValue = FrameHeight_;
		return S_OK;
	}

	/**
	 * URLLINKɕϊ
	 */
	virtual HRESULT __stdcall put_Link(BOOL v_value) throw()
	{
		Link_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * URLLINKɕϊ
	 */
	virtual HRESULT __stdcall is_Link(void) throw()
	{
		return Link_ ? S_OK : S_FALSE;
	}

	/**
	 * URLLINKɕϊtB^B
	 */
	virtual HRESULT __stdcall put_Link_Ext(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			LinkExt_ = v_value;
			dirty_ = TRUE;
			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * URLLINKɕϊtB^B
	 */
	virtual HRESULT __stdcall get_Link_Ext(BSTR* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		return LinkExt_.CopyTo(v_pValue);
	}

	/**
	 * EMBEDDEDLINKɕϊ
	 */
	virtual HRESULT __stdcall put_EMBEDDED(BOOL v_value) throw()
	{
		Embedded_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * EMBEDDEDLINKɕϊ
	 */
	virtual HRESULT __stdcall is_EMBEDDED(void) throw()
	{
		return Embedded_ ? S_OK : S_FALSE;
	}

	/**
	 * EMBEDDEDLINKɕϊtB^B
	 */
	virtual HRESULT __stdcall put_EMBEDDED_Ext(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			EmbeddedExt_ = v_value;
			dirty_ = TRUE;
			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * EMBEDDEDLINKɕϊtB^B
	 */
	virtual HRESULT __stdcall get_EMBEDDED_Ext(BSTR* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_FAIL;
		}
		return EmbeddedExt_.CopyTo(v_pValue);
	}

	/**
	 * URL̐
	 */
	virtual HRESULT __stdcall put_URL(BOOL v_value) throw()
	{
		Url_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * URL̐
	 */
	virtual HRESULT __stdcall is_URL(void) throw()
	{
		return Url_ ? S_OK : S_FALSE;
	}

	/**
	 * URL̐tB^
	 */
	virtual HRESULT __stdcall put_URL_Limit(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			UrlLimit_ = v_value;
			// dirty_ = TRUE; /// iΏۊOɂAsv
			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * URL̐tB^
	 */
	virtual HRESULT __stdcall get_URL_Limit(BSTR* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		return UrlLimit_.CopyTo(v_pValue);
	}

	/**
	 * VEBhEJ
	 */
	virtual HRESULT __stdcall put_OpenNewWindow(BOOL v_value) throw()
	{
		OpenNew_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * VEBhEJ
	 */
	virtual HRESULT __stdcall is_OpenNewWindow(void) throw()
	{
		return OpenNew_ ? S_OK : S_FALSE;
	}

protected:

	static inline void CHK(HRESULT hr)
	{
		if (FAILED(hr)) {
			AtlThrow(hr);
		}
	}

	BOOL dirty_;

	DWORD ImgLink_;
	CComBSTR ImgLinkExt_;

	DWORD Img_;
	CComBSTR ImgExt_;

	DWORD ImgSize_;
	DWORD ImgWidth_;
	DWORD ImgHeight_;

	DWORD UrlLink_;
	CComBSTR UrlLinkExt_;

	DWORD FrameWidth_;
	DWORD FrameHeight_;

	DWORD Link_;
	CComBSTR LinkExt_;

	DWORD Embedded_;
	CComBSTR EmbeddedExt_;

	DWORD Url_;
	CComBSTR UrlLimit_;

	DWORD OpenNew_;
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CSetting), CSetting);


HRESULT __stdcall CreateSetting(ISetting** v_ppSetting) throw()
{
	if ( !v_ppSetting) {
		return E_POINTER;
	}
	return CSetting::CreateInstance(v_ppSetting);
}


///

class __declspec(uuid("{D376DC12-4329-498b-AA2E-383E70E306F2}")) CSettingAcceptors
	: public ISettingAcceptors
	, public CComObjectRoot
{
public:
	BEGIN_COM_MAP(CSettingAcceptors)
		COM_INTERFACE_ENTRY(ISettingReader)
		COM_INTERFACE_ENTRY(ISettingAcceptors)
	END_COM_MAP( )

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT Init(ISettingReader* v_pSetting) throw()
	{
		if ( !v_pSetting) {
			return E_INVALIDARG;
		}

		try {
			HRESULT hr;

			pSetting_ = v_pSetting;

			// URL̐sv𔻒肷ANZv^\z܂B
			CComBSTR prefix;
			CComPtr<INameAcceptor> pURLPrefixAcceptor;
			hr = pSetting_->is_URL();
			if (FAILED(hr)) {
				return hr;
			}
			if (hr == S_OK) {
				hr = pSetting_->get_URL_Limit(&prefix);
				if (FAILED(hr)) {
					return hr;
				}
				hr = CreateSimpleNameAcceptor(prefix, &pURLPrefixAcceptor);
				if (FAILED(hr)) {
					return hr;
				}
			}

			// gq擾ISettingReader̊֐
			// ANZv^IuWFNgɂĊi[`
			const FilterPair filters[] = {
				{&ISettingReader::get_ImgLink_Ext, &pImgLinkAcceptor_},
				{&ISettingReader::get_Img_Ext, &pImgAcceptor_},
				{&ISettingReader::get_URLLink_Ext, &pURLLinkAcceptor_},
				{&ISettingReader::get_Link_Ext, &pLinkAcceptor_},
				{NULL, NULL}
			};

			// ̊gq[vŏ
			for (const FilterPair* p = filters; p->pGetter != NULL; ++p) {
				// `F[ANZv^̍쐬
				CComPtr<IMultiNameAcceptor> pMultiAcceptor;
				hr = CreateMultiNameAcceptor(TRUE, &pMultiAcceptor);
				if (FAILED(hr)) {
					return hr;
				}

				// URL~bg̃`FCւ̓o^
				if (pURLPrefixAcceptor) {
					hr = pMultiAcceptor->Add(pURLPrefixAcceptor);
					if (FAILED(hr)) {
						return hr;
					}
				}

				// gq̎擾
				CComBSTR exts;
				hr = (pSetting_->*(p->pGetter))(&exts);
				if (FAILED(hr)) {
					return hr;
				}
				if (exts && exts.Length() > 0) {
					// O}b`ÕANZv^쐬
					CComPtr<IMultiNameAcceptor> pMultiExtAcceptor;
					hr = CreateMultiNameAcceptor(FALSE, &pMultiExtAcceptor);
					if (FAILED(hr)) {
						return hr;
					}
					// gqXg}`ANZv^ݒ肷
					hr = ConfigureMultiPatternNameAcceptor(exts, pMultiExtAcceptor);
					if (FAILED(hr)) {
						return hr;
					}
					// pX𖼑Oɐ؂藎ƂA_v^̍쐬
					CComPtr<IStripedURLNameAcceptorAdaptor> pAcceptorAdaptor;
					hr = CreateStripedURLNameAcceptorAdaptor(pMultiExtAcceptor, &pAcceptorAdaptor);
					if (FAILED(hr)) {
						return hr;
					}

					// OANZv^A_v^̓o^
					hr = pMultiAcceptor->Add(pAcceptorAdaptor);
					if (FAILED(hr)) {
						return hr;
					}
				}
				
				// tB^oϐɓo^
				ATLASSERT( !*(p->ppFilter));
				hr = pMultiAcceptor.QueryInterface(p->ppFilter);
				if (FAILED(hr)) {
					return hr;
				}
			}
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	/**
	 * 摜ւ̃NIMGɕϊ܂B
	 */
	virtual HRESULT __stdcall is_ImgLink(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_ImgLink();
	}

	/**
	 * 摜ւ̃NIMGɕϊtB^
	 */
	virtual HRESULT __stdcall get_ImgLink_Ext(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_ImgLink_Ext(v_pValue);
	}

	/**
	 * 摜IMGɕϊ܂B
	 */
	virtual HRESULT __stdcall is_Img(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_Img();
	}

	/**
	 * 摜IMGɕϊtB^B
	 */
	virtual HRESULT __stdcall get_Img_Ext(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_Img_Ext(v_pValue);
	}

	/**
	 * 摜IMGɕϊTCY
	 */
	virtual HRESULT __stdcall is_Img_Size(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_Img_Size();
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall get_Img_Width(UINT* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_Img_Width(v_pValue);
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall get_Img_Height(UINT* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_Img_Height(v_pValue);
	}

	/**
	 * URLIMGɕϊTCY
	 */
	virtual HRESULT __stdcall is_URLLink(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_URLLink();
	}

	/**
	 * URLIMGɕϊtB^B
	 */
	virtual HRESULT __stdcall get_URLLink_Ext(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_URLLink_Ext(v_pValue);
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall get_IFrame_Width(UINT* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_IFrame_Width(v_pValue);
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall get_IFrame_Height(UINT* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_IFrame_Height(v_pValue);
	}

	/**
	 * URLLINKɕϊ
	 */
	virtual HRESULT __stdcall is_Link(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_Link();
	}

	/**
	 * URLLINKɕϊtB^B
	 */
	virtual HRESULT __stdcall get_Link_Ext(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_Link_Ext(v_pValue);
	}

	/**
	 * URL̐
	 */
	virtual HRESULT __stdcall is_URL(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_URL();
	}

	/**
	 * URL̐tB^
	 */
	virtual HRESULT __stdcall get_URL_Limit(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_URL_Limit(v_pValue);
	}

	/**
	 * VEBhEJ
	 */
	virtual HRESULT __stdcall is_OpenNewWindow(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_OpenNewWindow();
	}

	///

	virtual HRESULT __stdcall IsAcceptable_ImgLink(LPCWSTR v_url) throw()
	{
		ATLASSERT(pImgLinkAcceptor_);
		return pImgLinkAcceptor_->IsAcceptable(v_url);
	}

	virtual HRESULT __stdcall IsAcceptable_Img(LPCWSTR v_url) throw()
	{
		ATLASSERT(pImgAcceptor_);
		return pImgAcceptor_->IsAcceptable(v_url);
	}

	virtual HRESULT __stdcall IsAcceptable_URLLink(LPCWSTR v_url) throw()
	{
		ATLASSERT(pURLLinkAcceptor_);
		return pURLLinkAcceptor_->IsAcceptable(v_url);
	}

	virtual HRESULT __stdcall IsAcceptable_Link(LPCWSTR v_url) throw()
	{
		ATLASSERT(pLinkAcceptor_);
		return pLinkAcceptor_->IsAcceptable(v_url);
	}

protected:

	CComPtr<ISettingReader> pSetting_;

	CComPtr<INameAcceptor> pURLLinkAcceptor_;
	CComPtr<INameAcceptor> pImgLinkAcceptor_;
	CComPtr<INameAcceptor> pImgAcceptor_;
	CComPtr<INameAcceptor> pLinkAcceptor_;

	typedef HRESULT (__stdcall ISettingReader::*ExtGetterFuncPtr)(BSTR*);
	
	struct FilterPair {
		ExtGetterFuncPtr pGetter;
		INameAcceptor** ppFilter;
	};
};

HRESULT __stdcall CreateSettingAcceptors(ISettingReader* v_pSetting, ISettingAcceptors** v_ppSettingAcceptors) throw()
{
	if ( !v_pSetting) {
		return E_INVALIDARG;
	}
	if ( !v_ppSettingAcceptors) {
		return E_POINTER;
	}

	HRESULT hr;
	CComObject<CSettingAcceptors>* pSettingAcceptorsImpl = NULL;
	hr = CComObject<CSettingAcceptors>::CreateInstance(&pSettingAcceptorsImpl);
	if (FAILED(hr)) {
		return hr;
	}
	CComPtr<ISettingAcceptors> pSettingAcceptors(pSettingAcceptorsImpl);

	hr = pSettingAcceptorsImpl->Init(v_pSetting);
	if (FAILED(hr)) {
		return hr;
	}

	return pSettingAcceptors.CopyTo(v_ppSettingAcceptors);
}

