#pragma once

#include <atlwin.h>
#include "resource.h"

class CItemSelectInfo
{
public:
	CItemSelectInfo()
		: select_linked_image_( true )
		, select_linked_html_( false )
		, select_image_( false )
		, save_mode_( 1 )
		, open_mode_( 0 )
		, temp_name_( true )
		, use_item_limit_( true )
		, item_start_( 1 )
		, item_limit_( 50 )
		, use_image_size_( true )
		, image_size_width_( 200 )
		, image_size_height_( 200 )
		, use_linked_url_( false )
	{
		SetDefaultTempDir();
	}

	virtual ~CItemSelectInfo() {}

protected:

	bool select_linked_image_;

	bool select_linked_html_;

	bool select_image_;

	int save_mode_;

	int open_mode_;

	bool temp_name_;

	CString temp_path_;

	bool use_item_limit_;

	int item_limit_;

	int item_start_;

	bool use_image_size_;

	int image_size_width_;

	int image_size_height_;

	bool use_linked_url_;

	CString linked_url_;

public:

	void SetDefaultTempDir()
	{
		temp_path_ = "%TMP%";
	}

	inline bool is_select_linked_image() const
	{
		return select_linked_image_;
	}

	inline bool is_select_linked_html() const
	{
		return select_linked_html_;
	}

	inline bool is_select_image() const
	{
		return select_image_;
	}

	inline int get_save_mode() const
	{
		return save_mode_;
	}

	inline int get_open_mode() const
	{
		return open_mode_;
	}

	inline bool is_temp_name() const
	{
		return temp_name_;
	}

	inline CString get_temp_path() const
	{
		return temp_path_;
	}

	inline bool is_use_item_limit() const
	{
		return use_item_limit_;
	}

	inline int get_item_start() const
	{
		return item_start_;
	}

	inline int get_item_limit() const
	{
		return item_limit_;
	}

	inline bool is_use_image_size() const
	{
		return use_image_size_;
	}

	inline int get_image_size_width() const 
	{
		return image_size_width_;
	}

	inline int get_image_size_height() const
	{
		return image_size_height_;
	}

	inline CString get_linked_url() const
	{
		return linked_url_;
	}

	inline bool is_use_linked_url() const
	{
		return use_linked_url_;
	}

	void set_linked_url( const CString& v_linked_url )
	{
		linked_url_ = v_linked_url;
	}

};

class CItemSelectDlg :
	public CDialogImpl<CItemSelectDlg>,
	public CItemSelectInfo
{
public:
	enum { IDD = IDD_ITEMSELECTDLG };

	CItemSelectDlg(void);
	virtual ~CItemSelectDlg(void);

	BEGIN_MSG_MAP(CMyDialog)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		COMMAND_ID_HANDLER( IDOK, OnOK )
		COMMAND_ID_HANDLER( IDCANCEL, OnCancel )
		COMMAND_ID_HANDLER( IDC_BROWSE_FOLDER, OnBrowseForFolder )
		COMMAND_ID_HANDLER( IDC_ADD_NEXT, OnNextItemStartNumber )
		COMMAND_ID_HANDLER( IDC_SET_DEFAULT_TEMP_PATH, OnSetDefaultTempPath )
		COMMAND_ID_HANDLER( IDC_OPEN_FOLDER, OnOpenFolder )
	END_MSG_MAP()

	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);

	LRESULT OnOK(
		WORD wNotifyCode,
		WORD wID,
		HWND hWndCtl,
		BOOL& bHandled 
	);

	LRESULT OnCancel(
		WORD wNotifyCode,
		WORD wID,
		HWND hWndCtl,
		BOOL& bHandled 
	);
	

	LRESULT OnBrowseForFolder(
		WORD wNotifyCode,
		WORD wID,
		HWND hWndCtl,
		BOOL& bHandled 
	);

	LRESULT OnNextItemStartNumber(
		WORD wNotifyCode,
		WORD wID,
		HWND hWndCtl,
		BOOL& bHandled 
	);

	LRESULT OnSetDefaultTempPath(
		WORD wNotifyCode,
		WORD wID,
		HWND hWndCtl,
		BOOL& bHandled 
	);

	LRESULT OnOpenFolder(
		WORD wNotifyCode,
		WORD wID,
		HWND hWndCtl,
		BOOL& bHandled 
	);

protected:
	void load_setting();
	void save_setting();
};
