import random
import secrets

SECRETS = 'secrets'
RANDOM  = 'random'


class Random:
    __instance = None

    @staticmethod
    def get_instance(name):
        if Random.__instance is None:
            Random(name)
        return Random.__instance

    def __init__(self, name):
        if Random.__instance is not None:
            raise Exception("This class is a singleton!")
        else:
            if name == RANDOM:
                self.engine = random
            else:
                self.engine = secrets
            self.name = name
            Random.__instance = self

    def seed(self, seed):
        if self.name == SECRETS:
            return
        self.engine.seed(seed)

    def randint(self, a, b):
        a, b = int(a), int(b)
        if self.name == RANDOM:
            return self.engine.randint(a, b)
        return a + self.engine.randbelow(b - a + 1)

    def choice(self, seq):
        return self.engine.choice(seq)

    def uniform(self, a, b):
        a, b = int(a), int(b)
        if self.name == RANDOM:
            return self.engine.uniform(a, b)
        return self.engine.SystemRandom().uniform(a, b)