from PySide2 import QtWidgets as qtw
from os import path

from ui_about_minimisation import Ui_AboutMinimisationDialog


class AboutMinimisationDialog(qtw.QDialog):
    def __init__(self, parent):
        super().__init__(parent)
        self.ui = Ui_AboutMinimisationDialog()
        self.ui.setupUi(self)
        lang = parent.settings.value('language', 'en_US', type=str)
        filename = 'minimisation_{}.txt'.format(lang)
        if not path.exists(filename):
            filename = 'minimisation_en_US.txt'
            if not path.exists(filename):
                return
        text = open(filename, encoding='utf8').read()
        self.ui.minimTextEdit.setPlainText(text)
        self.setWindowTitle(parent.tr('What is Minimisation'))
        self.ui.closePushButton.setText(parent.tr('Close'))
        self.ui.closePushButton.clicked.connect(self.close)
