/* winduni.c -- unicode support for the windres program.
   Copyright 1997, 1998, 2000, 2001 Free Software Foundation, Inc.
   Written by Ian Lance Taylor, Cygnus Support.

   This file is part of GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

/* This file contains unicode support routines for the windres
   program.  Ideally, we would have generic unicode support which
   would work on all systems.  However, we don't.  Instead, on a
   Windows host, we are prepared to call some Windows routines.  This
   means that we will generate different output on Windows and Unix
   hosts, but that seems better than not really supporting unicode at
   all.  */

#include "bfd.h"
#include "bucomm.h"
#include "winduni.h"
#include "safe-ctype.h"

/* mbchar fix */
#include <iconv.h>

#ifdef _WIN32
#include <windows.h>
#endif

/* Convert an ASCII string to a unicode string.  We just copy it,
   expanding chars to shorts, rather than doing something intelligent.  */

void
unicode_from_ascii (length, unicode, ascii)
     int *length;
     unichar **unicode;
     const char *ascii;
{
/* mbchar fix */
  size_t len;
  const unsigned char *s;
  unsigned short *w;

  char *code;

  len = strlen (ascii) + 1;

  code = getenv ("CLANG");
  if (code == NULL)
    ;
  else
  if (! strcmp (code, "C-SJIS") ||
      ! strcmp (code, "C-JIS")  ||
      ! strcmp (code, "C-EUCJP"))
    {
      iconv_t cd;
      char *str, *tmp;
      const char *src;
      size_t ssrc, sstr, stmp;

      src = ascii;
      ssrc = len;
      sstr = stmp = len * sizeof (unichar);
      str = tmp = alloca (stmp);

      cd = iconv_open ("UCS-2","EUC-JP");
      if (cd != (iconv_t) -1 && str != NULL)
	{
	  int char_len;

	  iconv (cd, &src, &ssrc, &tmp, &stmp);
	  iconv_close (cd);

	  char_len = (sstr - stmp) / sizeof (unichar) - 1;
	  *unicode = ((unichar *) res_alloc (sstr - stmp));
	  
	  if (length != NULL)
	    *length = char_len;

	  for (s = str, w = *unicode; *s != 0 || *(s + 1) != 0; s += 2)
	    {
	      if (char_len-- <= 0) break;
	      *w++ = (((unsigned short) *s) << 8) + ((unsigned short) *(s + 1));
	    }
	  *w = 0;
	  return;
	}
    }

  *unicode = ((unichar *) res_alloc (len * sizeof (unichar)));

  if (length != NULL)
    *length = len - 1;

  for (s = ascii, w = *unicode; *s != '\0'; s++, w++)
    *w = *s & 0xff;
  *w = 0;
}

/* Print the unicode string UNICODE to the file E.  LENGTH is the
   number of characters to print, or -1 if we should print until the
   end of the string.  FIXME: On a Windows host, we should be calling
   some Windows function, probably WideCharToMultiByte.  */

void
unicode_print (e, unicode, length)
     FILE *e;
     const unichar *unicode;
     int length;
{
  while (1)
    {
      unichar ch;

      if (length == 0)
	return;
      if (length > 0)
	--length;

      ch = *unicode;

      if (ch == 0 && length < 0)
	return;

      ++unicode;

      if ((ch & 0x7f) == ch)
	{
	  if (ch == '\\')
	    fputs ("\\", e);
	  else if (ISPRINT (ch))
	    putc (ch, e);
	  else
	    {
	      switch (ch)
		{
		case ESCAPE_A:
		  fputs ("\\a", e);
		  break;

		case ESCAPE_B:
		  fputs ("\\b", e);
		  break;

		case ESCAPE_F:
		  fputs ("\\f", e);
		  break;

		case ESCAPE_N:
		  fputs ("\\n", e);
		  break;

		case ESCAPE_R:
		  fputs ("\\r", e);
		  break;

		case ESCAPE_T:
		  fputs ("\\t", e);
		  break;

		case ESCAPE_V:
		  fputs ("\\v", e);
		  break;

		default:
		  fprintf (e, "\\%03o", (unsigned int) ch);
		  break;
		}
	    }
	}
      else if ((ch & 0xff) == ch)
	fprintf (e, "\\%03o", (unsigned int) ch);
      else
	fprintf (e, "\\x%x", (unsigned int) ch);
    }
}
