import unittest
from MindMap import *

class MindMapTestCase(unittest.TestCase):
  def setUp(self):
    self.mindmap = MindMap('parent')
    self.child1 = MindMap('child1')
    self.child11 = MindMap('child11')
    self.child2 = MindMap('child2')
    self.child21 = MindMap('child21')
    self.child22 = MindMap('child22')

    self.mindmap.addChild(self.child1)
    self.mindmap.addChild(self.child2)
    self.child1.addChild(self.child11)
    self.child2.addChild(self.child21)
    self.child2.addChild(self.child22)

  def testSetGetMessage(self):
    self.assertEqual('parent', self.mindmap.getMessage())
    self.assertEqual('child1', self.child1.getMessage())
    self.assertEqual('child2', self.child2.getMessage())
    self.assertEqual('child11', self.child11.getMessage())
    self.assertEqual('child21', self.child21.getMessage())
    self.assertEqual('child22', self.child22.getMessage())

    self.mindmap.setMessage('message')
    self.assertEqual('message', self.mindmap.getMessage())

  def testSetGetCode(self):
    self.assertEqual(0, self.child1.getCode())
    self.assertEqual(0, self.child2.getCode())

    self.child1.setCode(123)
    self.child2.setCode(456)
    self.assertEqual(123, self.child1.getCode())
    self.assertEqual(456, self.child2.getCode())

  def testSetGetColor(self):
    self.assertEqual('black', self.mindmap.getColor())

    self.mindmap.setColor('blue')
    self.assertEqual('blue', self.mindmap.getColor())

  def testSetGetLink(self):
    self.assertEqual('', self.mindmap.getLink())

    self.mindmap.setLink('link')
    self.assertEqual('link', self.mindmap.getLink())

  def testSetGetMmbLink(self):
    self.assertEqual('', self.mindmap.getMmbLink())

    self.mindmap.setMmbLink('mmblink')
    self.assertEqual('mmblink', self.mindmap.getMmbLink())

  def testSetGetPicture(self):
    self.assertEqual('', self.mindmap.getPicture())

    self.mindmap.setPicture('picture')
    self.assertEqual('picture', self.mindmap.getPicture())

  def testChange(self):
    import time
    original_time = time.time
    time.time = mockTime

    self.mindmap.change('changed message', 'changed color')
    self.assertEquals('changed message', self.mindmap.getMessage())
    self.assertEquals('changed color', self.mindmap.getColor())
    self.assertEquals(time.mktime((2004, 1, 11, 14, 38, 44, 6, 11, 0)),
                      self.mindmap.time)

    time.time = original_time

  def testRefresh(self):
    changed = self.mindmap.refresh()
    self.assert_(not changed)
    self.assertEquals([self.child1, self.child2], self.mindmap.children)

  def testRefreshChild1(self):
    self.assertEquals([self.child11], self.child1.children)

    self.child11.setMessage("")
    changed = self.mindmap.refresh()
    self.assert_(changed)
    self.assertEquals([], self.child1.children)

  def testRefreshMindmap2(self):
    self.assertEquals([self.child1, self.child2], self.mindmap.children)

    self.child1.setMessage("")
    changed = self.mindmap.refresh()
    self.assert_(not changed)
    self.assertEquals([self.child1, self.child2], self.mindmap.children)

    self.child11.setMessage("")
    changed = self.mindmap.refresh()
    self.assert_(changed)
    self.assertEquals([self.child2], self.mindmap.children)

  def testMmbRefreshHaveRootMessage(self):
    child23 = MindMap('parent')
    self.child2.addChild(child23)
    self.child1.setMmbLink('foo')
    map = {'child2':'mmb0', 'bar':'mmb1'} # message:id

    self.assertEquals('foo', self.child1.getMmbLink())
    self.assertEquals('',    self.child2.getMmbLink())
    self.assertEquals('',    self.mindmap.getMmbLink())
    self.assertEquals('',    child23.getMmbLink())

    changed = self.mindmap.mmbRefresh(map, 'parent')    
    self.assert_(changed)
    self.assertEquals('',     self.child1.getMmbLink())
    self.assertEquals('mmb0', self.child2.getMmbLink())
    self.assertEquals(None,   self.mindmap.getMmbLink())
    self.assertEquals(None,   child23.getMmbLink())

    changed = self.mindmap.mmbRefresh(map, 'parent')
    self.assert_(not changed)
    self.assertEquals('',     self.child1.getMmbLink())
    self.assertEquals('mmb0', self.child2.getMmbLink())
    self.assertEquals(None,   self.mindmap.getMmbLink())
    self.assertEquals(None,   child23.getMmbLink())

def mockTime():
  return time.mktime((2004, 1, 11, 14, 38, 44, 6, 11, 0))


if __name__ == "__main__":
  unittest.main()
