import time
from Counter import Counter
from Composite import Composite
from Birthday import Birthday

class MindMapRoot(Counter):
  def __init__(self):
    Counter.__init__(self)
    self.decode_map = {}

  def add(self, parent_code, message):
    child = MindMap(message)
    if parent_code != None:
      parent = self.decode_map[parent_code]
      parent.addChild(child)
      child.setColor(parent.getColor())
    child.setCode(str(self.nextCount()))
    self.decode_map[child.getCode()] = child
    return child

  def change(self, code, message, color, link, picture):
    child = self.decode_map[code]
    child.change(message, color)
    child.setLink(link)
    child.setPicture(picture)

  def getRoot(self):
    return self.decode_map['0']

class MindMap(Birthday, Composite):
  def __init__(self, message):
    Birthday.__init__(self)
    Composite.__init__(self)
    self.setMessage(message)
    self.setLink('')
    self.setMmbLink('')
    self.setPicture('')
    self.setCode(0)
    self.setColor('black')

  def getMessage(self):
    return self.message
  def setMessage(self, message):
    self.message = message

  def getColor(self):
    return self.color
  def setColor(self, color):
    self.color = color

  def getCode(self):
    return self.code
  def setCode(self, code):
    self.code = code

  def getLink(self):
    return self.link
  def setLink(self, link):
    self.link = link

  def getMmbLink(self):
    if not hasattr(self, 'mmbLink'):
      self.mmbLink = ''
    return self.mmbLink
  def setMmbLink(self, mmbLink):
    self.mmbLink = mmbLink

  def getPicture(self):
    if not hasattr(self, 'picture'):
      self.picture = ''
    return self.picture
  def setPicture(self, picture):
    self.picture = picture

  def change(self, message, color):
    self.setMessage(message)
    self.setColor(color)
    self.rebirth()

  def refresh(self):
    changed = 0
    for child in self.children:
      result = child.refresh()
      changed = changed | result

    for child in self.children:
      if child.getMessage() == "":
        if child.children == []:
          self.removeChild(child)
          changed = 1

    return changed

  def mmbRefresh(self, map, root_message):
    changed = 0
    for child in self.children:
      result = child.mmbRefresh(map, root_message)
      changed = changed | result

    message = self.getMessage()
    if message == root_message:
      if None != self.getMmbLink():
        self.setMmbLink(None)
        return 1
      return changed
      
    if map.has_key(message):
      id = map[message]
      if id != self.getMmbLink():
        self.setMmbLink(id)
        changed = 1
      return changed

    if '' != self.getMmbLink():
      self.setMmbLink('')
      changed = 1    
    return changed
