var mm = {
  id_counter : 0,

  selection : {
    node : null,
    up : function() {
      if(! mm.selection.node) {
        return
      }
      if(mm.selection.node.isRoot) {
        return
      }
      var b = mm.selection.node.previousSibling
      if (b) {
        mm.selection.select(b)
      }
    },
    down : function() {
      if(! mm.selection.node) {
        return
      }
      if(mm.selection.node.isRoot) {
        return
      }
      var b = mm.selection.node.nextSibling
      if (b) {
        mm.selection.select(b)
      }
    },
    left : function() {
      if(mm.selection.node) {
        var b = mm.parent(mm.selection.node)
        if (b) {
          mm.selection.select(b)
        }
      }
    },
    right : function() {
      if(mm.selection.node) {
        var b = mm.firstChild(mm.selection.node)
        if (b) {
          mm.selection.select(b)
        }
      }
    },

    select : function(node) {
      mm.selection.unselectAll()
      var s = node.getElementsBySelector('tr td.name span.text')[0]
      s.style.background = 'silver'
      mm.selection.node = node
    },

    unselect : function(node) {
      var s = node.getElementsBySelector('tr td.name span.text')[0]
      s.style.background = ''
    },

    unselectAll : function() {
      var nodes = $$('table.node')
      for (var i = 0; i < nodes.size(); i++) {
        var node = nodes[i]
        if (node.id != 'node_prototype') {
          mm.selection.unselect(node)
        }
      }
      mm.selection.node = null
    },
  },

  move : {
    up : function(node) {
      if(node.isRoot) {
        return
      }
      var p = node.parentNode
      var s1 = node.previousSibling
      if (s1) {
        p.insertBefore(node, s1)
        mm.showChildren(node)
      }
    },
    down : function(node) {
      if(node.isRoot) {
        return
      }
      var p = node.parentNode
      var s1 = node.nextSibling
      if (s1) {
        var s2 = s1.nextSibling
        if (s2) {
          p.insertBefore(node, s2)
        } else {
          p.appendChild(node)
        }
        mm.showChildren(node)
      }
    },
    left : function(node) {
      var parent = mm.parent(node)
      if (! parent) {
        return
      }

      var pparent = mm.parent(parent)
      if (! pparent) {
        return
      }

      var pp = parent.parentNode
      var p1 = parent.nextSibling
      if (p1) {
        pp.insertBefore(node, p1)
      } else {
        pp.appendChild(node)
      }
      mm.showChildren(parent)
    },
    right : function(node) {
      var p = node.previousSibling
      if (! p) {
        return
      }
      mm.appendChild(p, node)
      mm.showChildren(p)
    },
  },

  appendChild : function(parent, child) {
    var p = parent.getElementsBySelector('tr td.children')[0]
    p.appendChild(child)
    mm.showChildren(parent)
    mm.showChildren(child)
    mm.hideEditArea(child)
  },

  delete : function(node) {
    var pn = node.parentNode
    var p = mm.parent(node)
    pn.removeChild(node)
    mm.showChildren(p)
    mm.selection.node = null
  },

  create : {
    newChild : function(node) {
      var c = mm.create.node()
      mm.appendChild(node, c)
      return c
    },

    newBrother : function(node) {
      if(node.isRoot) {
        return
      }

      var c = mm.create.node()

      var p = node.parentNode
      p.insertBefore(c, node.nextSibling)

      mm.showChildren(mm.parent(node))
      mm.showChildren(c)
      mm.hideEditArea(c)
      return c
    },

    node : function() {
      var node = $('node_prototype').cloneNode(true)
      node.id = 'node' + mm.id_counter
      mm.setName(node, node.id)
      mm.id_counter += 1
      return node
    },

    root : function() {
      var r = mm.create.node()
      r.isRoot = true

      return r
    },

  },

  setName : function(node, name) {
    var s = node.getElementsBySelector('tr td.name span')[0]
    s.childNodes[0].textContent = name

    var i = node.getElementsBySelector('tr td.name input')[0]
    i.value = name
  },

  getName : function(node) {
    var p = node.getElementsBySelector('tr td.name span')[0]
    return p.childNodes[0].textContent
  },


  showEditArea : function(node) {
    mm.selection.node = node

    var s = node.getElementsBySelector('tr td.name span.text')[0]
    s.style.display = 'none'

    var i = node.getElementsBySelector('tr td.name span.inputarea input')[0]
    i.style.display = ''
    i.value = mm.getName(node)
    i.focus()
    i.select()
  },

  hideEditArea : function(node) {
    var s = node.getElementsBySelector('tr td.name span.text')[0]
    s.style.display = ''

    var i = node.getElementsBySelector('tr td.name span.inputarea input')[0]
    i.style.display = 'none'
    if(i.value != "") {
      if(i.value != mm.getName(node)) {
        mm.command.edit(node.id, i.value)
        mm.command.exec()
      }
    }
  },

  hideAllEditArea : function() {
    var nodes = $$('table.node')
    for (var i = 0; i < nodes.size(); i++) {
      var node = nodes[i]
      if (node.id != 'node_prototype') {
        mm.hideEditArea(node)
      }
    }
  },

  ppparentNode : function(iconNode) {
    var p4 = iconNode.parentNode.parentNode.parentNode.parentNode
    return p4
  },

  hasChildren : function(node) {
    return mm.getChildren(node).size() != 0
  },

  getChildren : function(node) {
    var p = node.getElementsBySelector('tr td.children table')
    return p
  },

  firstChild : function(node) {
    return node.getElementsBySelector('tr td.children table')[0]
  },

  lastChild : function(node) {
    var c = node.getElementsBySelector('tr td.children')[0]
    var cns = c.childNodes

    return cns[cns.length - 1]
  },

  parent : function(node) {
    var p = node.parentNode.parentNode.parentNode.parentNode

    if (p == null) {
      return null
    }
    if (p.className != 'node') {
      return null
    }
    return p
  },

  showChildren : function(node) {
    var p
    p = node.getElementsBySelector('tr td.children')[0]
    p.style.display = ''

    p = node.getElementsBySelector('tr td.name span.plusicon')[0]
    p.style.display = 'none'

    p = node.getElementsBySelector('tr td.name span.minusicon')[0]
    if (mm.hasChildren(node)) {
      p.style.display = ''
    } else {
      p.style.display = 'none'
    }

    // line
    mm.refleshLine(node)
  },

  refleshLine : function(node) {
    var p = node.getElementsBySelector('tr td.line')[0]
    if (!mm.hasChildren(node) || mm.getChildren(node).size() == 1) {
      p.style.borderRightColor = 'white'
      p.style.display = 'none'
    } else {
      p.style.borderRightColor = 'green'
      p.style.display = ''

      var d = p.getElementsBySelector('div')[0]
      d.style.height = 0

      var cf = mm.firstChild (node)
      var cl = mm.lastChild (node)

      var cf_name = cf.getElementsBySelector('tr td.name span.text')[0]
      p.style.borderTopWidth = cf_name.offsetTop + cf_name.offsetHeight + 5

      var cl_name = cl.getElementsBySelector('tr td.name span.text')[0]
      p.style.borderBottomWidth = cl.offsetHeight - (cl_name.offsetTop + cl_name.offsetHeight)

      var d = p.getElementsBySelector('div')[0]
      d.style.height = 0
      d.style.height = p.clientHeight
    }

    var pa = mm.parent(node)
    if (pa) {
      mm.refleshLine(pa)
    }
  },

  hideChildren : function(node) {
    var p
    p = node.getElementsBySelector('tr td.children')[0]
    p.style.display = 'none'

    // line
    p = node.getElementsBySelector('tr td.line')[0]
    p.style.borderRightColor = 'white'
    p.style.display = 'none'

    p = node.getElementsBySelector('tr td.name span.minusicon')[0]
    p.style.display = 'none'

    p = node.getElementsBySelector('tr td.name span.plusicon')[0]
    if (mm.hasChildren(node)) {
      p.style.display = ''
    } else {
      p.style.display = 'none'
    }

    // line
    mm.refleshLine(node)
  },

  ENTER_KEY_CODE : 13,
  INSERT_KEY_CODE : 45,
  DELETE_KEY_CODE : 46,
  F2_KEY_CODE : 113,
  LEFT_KEY_CODE : 37,
  UP_KEY_CODE : 38,
  RIGHT_KEY_CODE : 39,
  DOWN_KEY_CODE : 40,
  key_timeStamp : null,

  keyPressed_onBody : function(event) {
    if (mm.key_timeStamp != event.timeStamp) {
      if(mm.selection.node) {
        var node_id = mm.selection.node.id
        if (event.keyCode == mm.ENTER_KEY_CODE) {
          mm.command.create('newBrother', node_id)
          mm.command.exec()
        }
        if (event.keyCode == mm.INSERT_KEY_CODE) {
          mm.command.create('newChild', node_id)
          mm.command.exec()
        }
        if (event.keyCode == mm.DELETE_KEY_CODE) {
          mm.command.delete(node_id)
          mm.command.exec()
        }
        if (event.keyCode == mm.F2_KEY_CODE) {
          mm.showEditArea(mm.selection.node)
        }
        if (event.keyCode == mm.F2_KEY_CODE) {
          mm.showEditArea(mm.selection.node)
        }
        if (event.keyCode == mm.LEFT_KEY_CODE) {
          if (event.ctrlKey) {
            mm.command.move('left', node_id)
            mm.command.exec()
          } else {
            mm.selection.left()
          }
        }
        if (event.keyCode == mm.UP_KEY_CODE) {
          if (event.ctrlKey) {
            mm.command.move('up', node_id)
            mm.command.exec()
          } else {
            mm.selection.up()
          }
        }
        if (event.keyCode == mm.RIGHT_KEY_CODE) {
          if (event.ctrlKey) {
            mm.command.move('right', node_id)
            mm.command.exec()
          } else {
            mm.selection.right()
          }
        }
        if (event.keyCode == mm.DOWN_KEY_CODE) {
          if (event.ctrlKey) {
            mm.command.move('down', node_id)
            mm.command.exec()
          } else {
            mm.selection.down()
          }
        }
      }
    }
  },

  keyPressed_onEditArea : function(event) {
    mm.key_timeStamp = event.timeStamp
    if (event.keyCode == mm.ENTER_KEY_CODE) {
      mm.hideEditArea(mm.selection.node)
    }
  },

  exec : {
    all : function(commands) {
      for (var i = 0; i < commands.length; i++) {
        mm.exec.one(commands[i])
      }
    },
    one : function(command) {
      words = command.split(',')
      return mm.exec[words[0]](words[1], words[2])
    },
    move : function(kind, node_id) {
      return mm.move[kind]($(node_id))
    },
    create : function(kind, parent_id) {
      return mm.create[kind]($(parent_id))
    },
    delete : function(node_id) {
      return mm.delete($(node_id))
    },
    edit : function(node_id, name) {
      return mm.setName($(node_id), name)
    },
  },

  command : {
    run_list : [],
    wait_list : [],
    append : function(command) {
      mm.command.wait_list.push(command)
    },
    exec : function() {
      mm.command.run_list = mm.command.run_list.concat(mm.command.wait_list)
      mm.command.wait_list = []
    },
    run : function() {
      var command = mm.command.run_list.shift()
      if (command) {
        mm.exec.one(command)
      }
    },
    move : function(kind, node_id) {
      mm.command.append('move,' + kind + ',' + node_id)
    },
    create : function(kind, parent_id) {
      mm.command.append('create,' + kind + ',' + parent_id)
    },
    delete : function(node_id) {
      mm.command.append('delete,' + node_id)
    },
    edit : function(node_id, name) {
      mm.command.append('edit,' + node_id + ',' + name)
    },
  },

  start : function() {
    html = ''
    html += '<div style="border:solid thin red; display:none">'
    html +=  '<table id="node_prototype" class="node">'
    html +=   '<tbody>'
    html +=    '<tr>'
    html +=     '<td class="name">'
    html +=      '<span class="text"'
    html +=             ' onclick="mm.selection.select(mm.ppparentNode(this))"'
    html +=             ' ondblclick="mm.showEditArea(mm.ppparentNode(this))">name</span>'
    html +=      '<span class="inputarea"><input type=text onkeypress="mm.keyPressed_onEditArea(event)"/></span>'
    html +=      '<span class="plusicon" onclick="mm.showChildren(mm.ppparentNode(this))">+</span>'
    html +=      '<span class="minusicon" onclick="mm.hideChildren(mm.ppparentNode(this))">-</span>'
    html +=     '</td>'
    html +=     '<td class="line"><div></div></td>'
    html +=     '<td class="children"></td>'
    html +=    '</tr>'
    html +=   '</tbody>'
    html +=  '</table>'
    html += '</div>'

    var d = document.createElement('div')
    d.style.display = 'none'
    d.innerHTML = html
    $$('body')[0].appendChild(d)

    window.onfocus = function() {mm.hideAllEditArea(); mm.selection.unselectAll()}
    window.onkeypress = function(event) {mm.keyPressed_onBody(event)}

    setInterval("mm.command.run()", 500)
  }
}
