using System.Collections;
using System.Threading;
using System;
using UnityEngine;
namespace MiMic.CsApi
{
	public class MiMicException:Exception
	{
		public MiMicException():base(){}
		public MiMicException(string s):base(s)
		{
		}
	}
	public class MiMicLib
	{
		public static Hashtable cloneAssoc(Hashtable a)
		{
			return (Hashtable)a.Clone();
		}
		public static string hexout(UInt32 i_val,int i_digit)
		{
			return i_val.ToString("x"+i_digit);
		}
		private static int _logid=0;
		public static void log(string i_s)
		{
			Debug.Log(_logid+":"+i_s);
			_logid++;
		}
	}
	/**
	 * MiMicAPIクラスの基底型.
	 */
	public class MiMicClass
	{
	}


	public class NBResult
	{
		protected MiMicRemoteMcuInterface.NBMiMicResult result;
		public NBResult(NBResult i_nb_result)
		{
			this.result=i_nb_result.result;
		}
		public NBResult(MiMicRemoteMcuInterface.NBMiMicResult i_result)
		{
			this.result=i_result;
		}
		public virtual bool isDone
		{
			get{return this.result.isDone;}
		}
	}	

	public class NBUIntResult :NBResult
	{

		public NBUIntResult(NBResult i_nb_result):base(i_nb_result)
		{
		}
		public NBUIntResult(MiMicRemoteMcuInterface.NBMiMicResult i_result):base(i_result)
		{
		}
		public virtual UInt32 getValue()
		{
			throw new MiMicException();
		}
	}
	public class NBUIntArrayResult :NBResult
	{
		public NBUIntArrayResult(MiMicRemoteMcuInterface.NBMiMicResult i_result):base(i_result)
		{
		}
		/**
		 * Must be override this function.
		 */
		public virtual UInt32[] getValues()
		{
			throw new MiMicException();
		}
	}
	
};
