(function(){
var DEV=LPCXpresso1769;
var BCF=DEV._BCF;
var EE=DEV._EE;
var isUndef=MiMicLib.isUndef;

/**
 * @see API manual.
 */
DEV.Pin=function Pin(i_mcu,i_pin,i_opt)
{
	try{
		if(isUndef(i_pin)){
			throw new MiMicException(EE.INVALID_PIN);
		}
		this._mcu=i_mcu;
		this._pininfo=DEV.getPinRegInfo(i_pin);
		//オプション設定するならする。
		if(!isUndef(i_opt)){
			this.setOpt(i_opt);
		}
	}catch(e){
		throw new MiMicException(e);
	}
}
DEV.Pin.prototype=
{	
	_PINSEL:[0x4002C000,0x4002C004,0x4002C008,0x4002C00C,0x4002C010,null,null,0x4002C0C0,null,0x4002C024,0x4002C028],
	_PINMODE:[0x4002C040,0x4002C044,0x4002C048,0x4002C04C,0x4002C050,0x4002C054,0x4002C058,0x4002C05C,null,0x4002C064],
	_PINMODE_OD:[0x4002C068,0x4002C06C,0x4002C070,0x4002C074,0x4002C078],
	_pininfo:null,
	_mcu:null,


	/**
	 * setPinのBCを生成します。
	 @param i_opt
	 setOptBcを参照してください。
	 @return
	 BCフラグメントを返します。
	 */
	BCF_setOpt:function BCF_setOpt(i_opt,i_db)
	{
		try{
			var bc="";
			//PINFUNC,PINMODEのbit位置
			//pinsel
			if(!isUndef(i_opt.sel)){
				
				//pinselAddrを得る
				bc+=BCF.setBit(this._PINSEL[this._pininfo.s],0x00000003,i_opt.sel,this._pininfo.smb,i_db);
			}
			//pinmode
			if(!isUndef(i_opt.mode)){
				if(this._pininfo.m==null){
					throw new MiMicException(EE.INVALID_CFG,"The pin does not support PINMODE. pininfo.");
				}
				bc+=BCF.setBit(this._PINMODE[this._pininfo.m],0x00000003,i_opt.mode,this._pininfo.smb,i_db);
			}
			//pinmode_od
			if(!isUndef(i_opt.od)){
				if(this._pininfo.o==null){
					throw new MiMicException(EE.INVALID_CFG,"The pin does not support PINMODE_OD. pininfo.");
				}
				bc+=BCF.setBit(this._PINMODE_OD[this._pininfo.o],0x00000001,i_opt.od,this._pininfo.ob,i_db);
			}
			return bc;
		}catch(e){
			throw new MiMicException(e);
		}
	},
	/**
	 * @see API manual
	 */
	setOpt:function setOpt(i_opt)
	{
		try{
			var db=new Array();
			var bc=this.BCF_setOpt(i_opt,db);
			if(bc.length==0){
				throw new MiMicException("i_opt is empty or invalid.");
			}
			//MiMicBCを生成して実行
			this._mcu.callMiMicWithCheck(bc+BCF.END,db);
		}catch(e){
			throw new MiMicException(e);
		}
		return;
	}
}

}());