#!/usr/bin/ruby
#
require 'uri'
require 'digest/md5'

class MusicCategory
	@parent
	@path
	@name
	@groupId
	@targetId
	@child
	@depth
	
	def initialize root, base, targetexts, classId, index  = 0, depth = 0, parent = nil
		@path = base
		@name = (depth == 0 ) ? $RES['main.check.allMusic'] : File.basename( base )
		@child = Array.new
		@groupId = classId
		@targetId = classId + '_' + index.to_s
		@depth = depth
		@parent = parent
		index = 0
		Dir.foreach(root + '/' + base){|file|
			if ( File::Stat.new(root + '/' +  base + '/' + file).directory? ) && ( file != '.' ) && ( file != '..' )
				@child.push MusicCategory.new( root, base + '/' + file, targetexts, @targetId, index, depth + 1, self)
				index += 1
			else
				@child.push base + '/' + file if targetexts.include? File.extname( file ).downcase
 			end
		}
		# @child.sort
	end

	def classId
		return @targetId
	end

	def groupId
		return @groupId
	end

	def path
		return @path
	end

	def name
		return @name
	end
	
	def depth
		return @depth
	end

	def has_dir
		@child.each{|elem|
			return true if elem.kind_of? MusicCategory
		}
		return false
	end
	
	def has_file_r
		@child.each{|elem|
			return true if elem.kind_of? String
			return true if elem.has_file_r != false
		}
		return false	
	end

	def has_file
		@child.each{|elem|
			return true if elem.kind_of? String
		}
		return false
	end

	def each_dir
		@child.each{|elem|
			yield elem if elem.kind_of? MusicCategory
		}
	end
	
	def each_file
		@child.each{|elem|
			yield elem if elem.kind_of? String
		}
	end

	def <=> target
		return @path <=> target.path if target.kind_of?(MusicCategory)
		return @path <=> target if target.kind_of?(String)
		return nil
	end
end

# use for debug
def displayEnv
	ENV.each{|key,val|
		print key + " => " + val + "<br/>"
	}
end

# use for debug
def displayCGI
	$CGI.params.each{|key,val|
		print key + " => " + val[0] + "<br/>"
	}
end

def displayHtmlHeader
	print "Content-type: text/html\n\n"
end

def displayExceptionMessage e
	print "#{e.message} in  #{e.class}<br/>"
	trace = e.backtrace
	print "from #{File.basename(trace.shift)} <br/>"
end

def validateLoginUser userName, password
	return false if userName == nil
	return false if password == nil
	return false if $USERINFO[userName.to_s] == nil
	return Digest::MD5.hexdigest(userName + ":" + password) == $USERINFO[userName.to_s]
end

def createSupportedFileExtList
	result = Array.new
	Dir.open($CONF['cgi-bin'] + '/filter'){|file|
		if !file.directory? && File.extname( file ) == ".rb"
			result.push "." + File.basename( file, ".rb" )
		end	
	}
end

def loadConfig config
	result = Hash.new	

	open( config ).each_line{|line|
		line.chomp!
		
		v = line.split('=')
		if v.size > 1 then
			result[v[0]] = v[1]
		elsif v.size == 1 then
			result[v[0]] = ''
		end
	}
	return result
end

def writeCSSRoot source
	print "\n<style type=\"text/css\"><!--\n"
	writeCSSInnerMusicCategory source
	print "--></style>\n"
end

def saveSelectedItemByPlaylist cgi, f, musicWebRoot
	user = cgi['loginUser'].to_s
	md5 = cgi['loginUserMD5'].to_s
	type = cgi['fileType'].to_s
	regexp = Regexp.new("[^#{URI::PATTERN::ALNUM}\.\/]")
	f.write( "#EXTM3U\n" )
	cgi.each{|key,value|
		if /file[0-9]+@/ =~ key
			f.write "#EXTINF:-1,#{value[0]}\n"
			addr = musicWebRoot.clone
			addr.sub! "${type}", type
			addr.sub! "${file}", URI.escape(value[0], regexp)
			addr.sub! "${user}", user
			addr.sub! "${md5}",  Digest::MD5.hexdigest(md5 + ":" + type + ":" + value[0])
			f.write addr + "\n"
		end
	}
end

def writeCSSInnerMusicCategory source
	print "div.#{source.classId}{ display:none; }\n" if source.has_dir
	source.each_dir{|dir|
		writeCSSInnerMusicCategory dir
	}
end

def writeCategoryBoxRoot source
	print "\n"
	writeCategoryBox source
end

def writeCategoryBox source
	return if source.has_file_r == false

	print "<table id=\"category@#{source.classId}\" width=\"100%\" bgcolor=\"#ccffcc\"><tr>"
	print "<td width=\"#{source.depth * 12 }\"></td>" if source.depth > 0 
	print "<td width=\"1\"><input type=\"checkbox\" name=\"checkbox@#{source.classId}\" value=\"#{source.name}\" onclick=\"checkAllChild( '#{source.classId}')\"></td>"
	print "<td>"
	print "<a href=\"javascript:treeExpand('#{source.groupId}','#{source.classId}');\">" if source.depth > 0
	print source.name
	print "</a>" if source.depth > 0 
	print "</td></tr></table>\n"
	print "<div class=\"#{source.groupId}\" id=\"child@#{source.classId}\">"
	if source.has_dir != false
		source.each_dir{|dir|
			writeCategoryBox dir
		}
	end
	if source.has_file != false
		print "<table id=\"file@#{source.classId}\" width=\"100%\" bgcolor=\"#f0fff0\">"
		index = 0
		source.each_file{|file|
			print "<tr>"
			print "<td width=\"#{(source.depth+1)*12 }\" bgcolor=\"#{(index % 2 == 0) ? "#f0fff0" : "#e0ffe0"}\" ></td>" 
			print "<td width=\"1\" bgcolor=\"#{(index % 2 == 0) ? "#f0fff0" : "#e0ffe0"}\"><input type=\"checkbox\" name=\"file#{index}@#{source.classId}\", value=\"#{file}\"></td>"
			print "<td bgcolor=\"#{(index % 2 == 0) ? "#f0fff0" : "#e0ffe0"}\">"
			print File.basename( file ) + "<br/>"
			print "</td></tr>"
			index = index + 1
		}
		print "</table>\n"
	end
	print "</div>"
end


