#!/usr/bin/ruby

require 'tempfile'
require 'cgi'
require 'digest/md5'

begin
	require 'conf/millefee.conf.rb'
	require $MUSIC_SERVER_RHTML_ROOT + '/lib/libMusicServer.rb'
	
	$CGI = CGI.new
	$CONF = loadConfig $MUSIC_SERVER_RHTML_ROOT + '/conf/password.conf.rhtml'

	ssl = $CGI.params['useSSL'].to_s
	user = $CGI.params['loginUser'].to_s
	md5 = $CONF[user]

	raise if md5 != $CGI.params['loginUserMD5'].to_s

	File.open( "temp.tmp", "w" ){|f|
		$CGI.params.each{|key,val|
			f.write key + " => " + val.to_s + "\n"
		}
	}
	url = ( ( ssl == '1' ) ? "https://" : "http://" ) + ENV['HTTP_HOST'] + File.dirname(ENV['SCRIPT_NAME']) + "/mediadlfilter.rb"
	url += "?type=${type}&file=${file}&user=${user}&md5=${md5}"
	playlist = Tempfile.open 'playlist'
	saveSelectedItemByPlaylist $CGI.params, playlist, url
	playlist.pos = 0
rescue Exception => e
	begin
		displayHtmlHeader
		displayExceptionMessage e
	rescue
		print "Content-type: text/html\n\n"
	end
	exit
end
param = {
	'status' => 'OK',
	'type'   => 'audio/playlist',
	'length' => playlist.stat.size,
	'Content-Disposition' => "attachment; filename=\"playlist.m3u\""
}
print $CGI.header(param)
print playlist.read
