#!/usr/bin/ruby

require 'cgi'
require 'tempfile'

$WMA_LAME_PARAM	= "--vbr-new -b128 -h -V0"

# wma -> mp3 convert stream
def execute(cgi, sourceFilename)
	return if !File.exist? sourceFilename

	param = {
		'status' => 'OK',
		'type'   => 'audio/mpeg',
		'length' => '-1',
		'Content-Disposition' => "attachment; filename=\"#{File.basename(sourceFilename)}\""
	}
	print cgi.header(param)
	
	file = Tempfile.open( 'music_server_fifo' )
	fifo = file.path
	file.close true

	file = Tempfile.open( 'music_server_sh' )
	file.write "#!/usr/bin/sh\n"
	file.write "mkfifo #{fifo} >& /dev/null\n"
	file.write "mplayer \"#{sourceFilename}\" -ao pcm:file=#{fifo} < /dev/null >& /dev/null &\n"
	file.write "cat #{fifo}|lame #{$WMA_LAME_PARAM} - -\n"
	file.write "rm -f #{fifo}\n"
	file.close false
	system "sh #{file.path}"
end

