/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private final HashMap<K, V> backingMap;
    private ListMapEntry<K, V>[] entries;

    public static void main(String[] args) {
        ListMap<String, String> map = new ListMap<String, String>();
        map.put("bob", "hello");
        System.out.println((String)map.get("bob"));
        map.remove("bob");
        System.out.println(map.size());
        map.put("abc", "1");
        map.put("def", "2");
        map.put("ghi", "3");
        map.put("jkl", "4");
        map.put("mno", "5");
        System.out.println((String)map.get("ghi"));
    }

    public ListMap() {
        this.entries = new ListMapEntry[4];
        this.backingMap = new HashMap(4);
    }

    public ListMap(int initialCapacity) {
        this.entries = new ListMapEntry[initialCapacity];
        this.backingMap = new HashMap(initialCapacity);
    }

    public ListMap(Map<? extends K, ? extends V> map) {
        this.entries = new ListMapEntry[map.size()];
        this.backingMap = new HashMap(map.size());
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    public Map.Entry<K, V> getEntry(int index) {
        return this.entries[index];
    }

    public V getValue(int index) {
        return (V)((ListMapEntry)this.entries[index]).value;
    }

    public K getKey(int index) {
        return (K)((ListMapEntry)this.entries[index]).key;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean keyEq(Object keyA, Object keyB) {
        return keyA.hashCode() == keyB.hashCode() ? keyA == keyB || keyA.equals(keyB) : false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.backingMap.containsKey(key)) {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                ListMapEntry<K, V> entry = this.entries[i];
                if (!ListMap.keyEq(((ListMapEntry)entry).key, key)) continue;
                ((ListMapEntry)entry).value = value;
                break;
            }
        } else {
            int size = this.size();
            if (size == this.entries.length) {
                ListMapEntry<K, V>[] tmpEntries = this.entries;
                this.entries = new ListMapEntry[size * 2];
                System.arraycopy(tmpEntries, 0, this.entries, 0, size);
            }
            this.entries[size] = new ListMapEntry<K, V>(key, value);
        }
        return this.backingMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V element = this.backingMap.remove(key);
        if (element != null) {
            int i;
            int size = this.size() + 1;
            int removedIndex = -1;
            for (i = 0; i < size; ++i) {
                ListMapEntry<K, V> entry = this.entries[i];
                if (!ListMap.keyEq(((ListMapEntry)entry).key, key)) continue;
                removedIndex = i;
                break;
            }
            assert (removedIndex >= 0);
            --size;
            for (i = removedIndex; i < size; ++i) {
                this.entries[i] = this.entries[i + 1];
            }
        }
        return element;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    public ListMap<K, V> clone() {
        ListMap<K, V> clone = new ListMap<K, V>(this.size());
        clone.putAll(this);
        return clone;
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListMapEntry<K, V>
    implements Map.Entry<K, V>,
    Cloneable {
        private final K key;
        private V value;

        public ListMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        public ListMapEntry<K, V> clone() {
            return new ListMapEntry<K, V>(this.key, this.value);
        }
    }
}

