/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.android;

import android.opengl.GLSurfaceView;
import java.util.logging.Logger;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;

public class AndroidConfigChooser
implements GLSurfaceView.EGLConfigChooser {
    private static final Logger logger = Logger.getLogger(AndroidConfigChooser.class.getName());
    protected int clientOpenGLESVersion = 0;
    protected EGLConfig bestConfig = null;
    protected EGLConfig fastestConfig = null;
    protected EGLConfig choosenConfig = null;
    protected ConfigType type;
    protected int pixelFormat;
    protected boolean verbose = false;
    private static final int EGL_OPENGL_ES2_BIT = 4;

    public AndroidConfigChooser(ConfigType type, boolean verbose) {
        this.type = type;
        this.verbose = verbose;
    }

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
        logger.info("GLSurfaceView asks for egl config, returning: ");
        this.logEGLConfig(this.choosenConfig, display, egl);
        return this.choosenConfig;
    }

    public boolean findConfig(EGL10 egl, EGLDisplay display) {
        if (this.type == ConfigType.BEST) {
            ComponentSizeChooser compChooser = new ComponentSizeChooser(8, 8, 8, 8, 32, 0);
            this.choosenConfig = compChooser.chooseConfig(egl, display);
            if (this.choosenConfig == null) {
                compChooser = new ComponentSizeChooser(8, 8, 8, 0, 32, 0);
                this.choosenConfig = compChooser.chooseConfig(egl, display);
                if (this.choosenConfig == null) {
                    compChooser = new ComponentSizeChooser(8, 8, 8, 8, 16, 0);
                    this.choosenConfig = compChooser.chooseConfig(egl, display);
                    if (this.choosenConfig == null) {
                        compChooser = new ComponentSizeChooser(8, 8, 8, 0, 16, 0);
                        this.choosenConfig = compChooser.chooseConfig(egl, display);
                    }
                }
            }
            logger.info("JME3 using best EGL configuration available here: ");
        } else {
            ComponentSizeChooser compChooser = new ComponentSizeChooser(5, 6, 5, 0, 16, 0);
            this.choosenConfig = compChooser.chooseConfig(egl, display);
            logger.info("JME3 using fastest EGL configuration available here: ");
        }
        if (this.choosenConfig != null) {
            logger.info("JME3 using choosen config: ");
            this.logEGLConfig(this.choosenConfig, display, egl);
            this.pixelFormat = this.getPixelFormat(this.choosenConfig, display, egl);
            this.clientOpenGLESVersion = this.getOpenGLVersion(this.choosenConfig, display, egl);
            return true;
        }
        logger.severe("###ERROR### Unable to get a valid OpenGL ES 2.0 config, nether Fastest nor Best found! Bug. Please report this.");
        this.clientOpenGLESVersion = 1;
        this.pixelFormat = 0;
        return false;
    }

    private int getPixelFormat(EGLConfig conf, EGLDisplay display, EGL10 egl) {
        int[] value = new int[1];
        int result = 4;
        egl.eglGetConfigAttrib(display, conf, 12324, value);
        if (value[0] == 8) {
            result = 1;
        }
        if (this.verbose) {
            logger.info("Using PixelFormat " + result);
        }
        return -2;
    }

    private int getOpenGLVersion(EGLConfig conf, EGLDisplay display, EGL10 egl) {
        int[] value = new int[1];
        int result = 1;
        egl.eglGetConfigAttrib(display, conf, 12352, value);
        if ((value[0] & 4) != 0) {
            result = 2;
        }
        return result;
    }

    public void logEGLConfig(EGLConfig conf, EGLDisplay display, EGL10 egl) {
        int[] value = new int[1];
        egl.eglGetConfigAttrib(display, conf, 12324, value);
        logger.info(String.format("EGL_RED_SIZE  = %d", value[0]));
        egl.eglGetConfigAttrib(display, conf, 12323, value);
        logger.info(String.format("EGL_GREEN_SIZE  = %d", value[0]));
        egl.eglGetConfigAttrib(display, conf, 12322, value);
        logger.info(String.format("EGL_BLUE_SIZE  = %d", value[0]));
        egl.eglGetConfigAttrib(display, conf, 12321, value);
        logger.info(String.format("EGL_ALPHA_SIZE  = %d", value[0]));
        egl.eglGetConfigAttrib(display, conf, 12325, value);
        logger.info(String.format("EGL_DEPTH_SIZE  = %d", value[0]));
        egl.eglGetConfigAttrib(display, conf, 12326, value);
        logger.info(String.format("EGL_STENCIL_SIZE  = %d", value[0]));
        egl.eglGetConfigAttrib(display, conf, 12352, value);
        logger.info(String.format("EGL_RENDERABLE_TYPE  = %d", value[0]));
        egl.eglGetConfigAttrib(display, conf, 12339, value);
        logger.info(String.format("EGL_SURFACE_TYPE  = %d", value[0]));
    }

    public int getClientOpenGLESVersion() {
        return this.clientOpenGLESVersion;
    }

    public void setClientOpenGLESVersion(int clientOpenGLESVersion) {
        this.clientOpenGLESVersion = clientOpenGLESVersion;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] mValue;
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;

        public ComponentSizeChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            super(new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12344});
            this.mValue = new int[1];
            this.mRedSize = redSize;
            this.mGreenSize = greenSize;
            this.mBlueSize = blueSize;
            this.mAlphaSize = alphaSize;
            this.mDepthSize = depthSize;
            this.mStencilSize = stencilSize;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }
    }

    private abstract class BaseConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private boolean bClientOpenGLESVersionSet = false;
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] configSpec) {
            this.mConfigSpec = this.filterConfigSpec(configSpec);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                return null;
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig config = this.chooseConfig(egl, display, configs);
            return config;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

        private int[] filterConfigSpec(int[] configSpec) {
            if (this.bClientOpenGLESVersionSet) {
                return configSpec;
            }
            int len = configSpec.length;
            int[] newConfigSpec = new int[len + 2];
            System.arraycopy(configSpec, 0, newConfigSpec, 0, len - 1);
            newConfigSpec[len - 1] = 12352;
            newConfigSpec[len] = 4;
            newConfigSpec[len + 1] = 12344;
            this.bClientOpenGLESVersionSet = true;
            return newConfigSpec;
        }
    }

    public static enum ConfigType {
        FASTEST,
        BEST,
        LEGACY;

    }
}

