/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.ColorRGBA;
import com.jme3.texture.Image;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

class TexturePixel
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(TexturePixel.class.getName());
    public float intensity;
    public float red;
    public float green;
    public float blue;
    public float alpha;

    TexturePixel() {
    }

    public void fromColor(ColorRGBA colorRGBA) {
        this.intensity = 0.0f;
        this.red = colorRGBA.r;
        this.green = colorRGBA.g;
        this.blue = colorRGBA.b;
        this.alpha = colorRGBA.a;
    }

    public void fromImage(Image.Format imageFormat, ByteBuffer data, int pixelIndex) {
        switch (imageFormat) {
            case ABGR8: {
                int firstByteIndex = pixelIndex << 2;
                byte pixelValue = data.get(firstByteIndex);
                this.alpha = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 1);
                this.blue = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 2);
                this.green = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 3);
                this.red = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                break;
            }
            case RGBA8: {
                int firstByteIndex = pixelIndex << 2;
                byte pixelValue = data.get(firstByteIndex);
                this.red = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 1);
                this.green = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 2);
                this.blue = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 3);
                this.alpha = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                break;
            }
            case BGR8: {
                int firstByteIndex = pixelIndex * 3;
                byte pixelValue = data.get(firstByteIndex);
                this.blue = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 1);
                this.green = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 2);
                this.red = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                this.alpha = 1.0f;
                break;
            }
            case RGB8: {
                int firstByteIndex = pixelIndex * 3;
                byte pixelValue = data.get(firstByteIndex);
                this.red = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 1);
                this.green = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get(firstByteIndex + 2);
                this.blue = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                this.alpha = 1.0f;
                break;
            }
            case Luminance8: {
                byte pixelValue = data.get(pixelIndex);
                this.intensity = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                break;
            }
            default: {
                LOGGER.log(Level.FINEST, "Unknown type of texture: {0}. Black pixel used!", (Object)imageFormat);
                this.alpha = 0.0f;
                this.green = 0.0f;
                this.red = 0.0f;
                this.blue = 0.0f;
                this.intensity = 0.0f;
            }
        }
    }

    public void merge(TexturePixel pixel) {
        float oneMinusAlpha = 1.0f - pixel.alpha;
        this.red = oneMinusAlpha * this.red + pixel.alpha * pixel.red;
        this.green = oneMinusAlpha * this.green + pixel.alpha * pixel.green;
        this.blue = oneMinusAlpha * this.blue + pixel.alpha * pixel.blue;
    }

    public void clear() {
        this.alpha = 0.0f;
        this.green = 0.0f;
        this.red = 0.0f;
        this.blue = 0.0f;
        this.intensity = 0.0f;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

