/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.file;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pointer {
    private BlenderContext blenderContext;
    private int pointerLevel;
    private long oldMemoryAddress;
    public boolean function;

    public Pointer(int pointerLevel, boolean function, BlenderContext blenderContext) {
        this.pointerLevel = pointerLevel;
        this.function = function;
        this.blenderContext = blenderContext;
    }

    public void fill(BlenderInputStream inputStream) {
        this.oldMemoryAddress = inputStream.readPointer();
    }

    public List<Structure> fetchData(BlenderInputStream inputStream) throws BlenderFileException {
        if (this.oldMemoryAddress == 0L) {
            throw new NullPointerException("The pointer points to nothing!");
        }
        List<Structure> structures = null;
        FileBlockHeader dataFileBlock = this.blenderContext.getFileBlock(this.oldMemoryAddress);
        if (this.pointerLevel > 1) {
            int pointersAmount = dataFileBlock.getSize() / inputStream.getPointerSize() * dataFileBlock.getCount();
            for (int i = 0; i < pointersAmount; ++i) {
                inputStream.setPosition(dataFileBlock.getBlockPosition() + inputStream.getPointerSize() * i);
                long oldMemoryAddress = inputStream.readPointer();
                if (oldMemoryAddress == 0L) continue;
                Pointer p = new Pointer(this.pointerLevel - 1, this.function, this.blenderContext);
                p.oldMemoryAddress = oldMemoryAddress;
                if (structures == null) {
                    structures = p.fetchData(inputStream);
                    continue;
                }
                structures.addAll(p.fetchData(inputStream));
            }
        } else {
            inputStream.setPosition(dataFileBlock.getBlockPosition());
            structures = new ArrayList<Structure>(dataFileBlock.getCount());
            for (int i = 0; i < dataFileBlock.getCount(); ++i) {
                Structure structure = this.blenderContext.getDnaBlockData().getStructure(dataFileBlock.getSdnaIndex());
                structure.fill(inputStream);
                structures.add(structure);
            }
            return structures;
        }
        return structures;
    }

    public boolean isFunction() {
        return this.function;
    }

    public boolean isNull() {
        return this.oldMemoryAddress == 0L;
    }

    public boolean isNotNull() {
        return this.oldMemoryAddress != 0L;
    }

    public long getOldMemoryAddress() {
        return this.oldMemoryAddress;
    }

    public String toString() {
        return this.oldMemoryAddress == 0L ? "{$null$}" : "{$" + this.oldMemoryAddress + "$}";
    }

    public int hashCode() {
        return 31 + (int)(this.oldMemoryAddress ^ this.oldMemoryAddress >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pointer other = (Pointer)obj;
        return this.oldMemoryAddress == other.oldMemoryAddress;
    }
}

