/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.animation.BoneTrack;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintSizeLike
extends Constraint {
    private static final int SIZELIKE_X = 1;
    private static final int SIZELIKE_Y = 2;
    private static final int SIZELIKE_Z = 4;
    private static final int LOCLIKE_OFFSET = 128;

    public ConstraintSizeLike(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, boneOMA, influenceIpo, blenderContext);
    }

    public void affectAnimation(Animation animation, int targetIndex) {
        Vector3f targetScale = this.getTargetLocation();
        BoneTrack track = (BoneTrack)this.getTrack(animation, targetIndex);
        if (track != null) {
            int flag = ((Number)this.data.getFieldValue("flag")).intValue();
            Vector3f[] scales = track.getScales();
            int maxFrames = scales.length;
            for (int frame = 0; frame < maxFrames; ++frame) {
                Vector3f offset = Vector3f.ZERO;
                if ((flag & 0x80) != 0) {
                    offset = scales[frame].clone();
                }
                if ((flag & 1) != 0) {
                    scales[frame].x = targetScale.x;
                } else if ((flag & 2) != 0) {
                    scales[frame].y = targetScale.y;
                } else if ((flag & 4) != 0) {
                    scales[frame].z = targetScale.z;
                }
                scales[frame].addLocal(offset);
            }
            track.setKeyframes(track.getTimes(), track.getTranslations(), track.getRotations(), scales);
        }
    }

    public ConstraintType getType() {
        return ConstraintType.CONSTRAINT_TYPE_SIZELIKE;
    }
}

