/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.math.Quaternion;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.objects.Properties;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlenderHelper {
    protected final int blenderVersion;
    protected boolean fixUpAxis;
    protected Quaternion upAxisRotationQuaternion;

    public AbstractBlenderHelper(String blenderVersion) {
        this.blenderVersion = Integer.parseInt(blenderVersion);
    }

    public void setyIsUpAxis(boolean fixUpAxis) {
        this.fixUpAxis = fixUpAxis;
        if (fixUpAxis) {
            this.upAxisRotationQuaternion = new Quaternion().fromAngles(-1.5707964f, 0.0f, 0.0f);
        }
    }

    public void clearState() {
    }

    protected boolean isBlank(String text) {
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isWhitespace(text.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected FloatBuffer createFloatBuffer(List<float[]> data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(4 * data.size());
        for (float[] v : data) {
            if (v != null) {
                buff.put(v[0]).put(v[1]).put(v[2]).put(v[3]);
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    protected Properties loadProperties(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pProperties;
        Properties properties = null;
        Structure id2 = (Structure)structure.getFieldValue("ID");
        if (id2 != null && (pProperties = (Pointer)id2.getFieldValue("properties")).isNotNull()) {
            Structure propertiesStructure = pProperties.fetchData(blenderContext.getInputStream()).get(0);
            properties = new Properties();
            properties.load(propertiesStructure, blenderContext);
        }
        return properties;
    }

    public abstract boolean shouldBeLoaded(Structure var1, BlenderContext var2);
}

