/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.BatchedGeometry;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.IntMap;
import com.jme3.util.SafeArrayList;
import com.jme3.util.TempVars;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryBatch
extends Geometry {
    private SafeArrayList<BatchedGeometry> children = new SafeArrayList<BatchedGeometry>(BatchedGeometry.class);
    private List<Geometry> tmpList = new ArrayList<Geometry>();
    private boolean needMeshUpdate = false;

    public GeometryBatch() {
        this("GeometryBatch");
    }

    public GeometryBatch(String name) {
        this.name = name;
        this.addControl(new ControlUpdate());
    }

    public BatchedGeometry batch(Geometry geom) {
        this.tmpList.clear();
        Mesh m = new Mesh();
        if (this.mesh != null) {
            this.tmpList.add(this);
        }
        this.tmpList.add(geom);
        List<BatchedGeometry> l = this.mergeGeometries(m, this.tmpList);
        this.mesh = m;
        this.mesh.updateCounts();
        this.mesh.updateBound();
        return l.get(0);
    }

    public List<BatchedGeometry> batch(List<Geometry> geom) {
        if (this.mesh != null) {
            geom.add(0, this);
        }
        Mesh m = new Mesh();
        List<BatchedGeometry> l = this.mergeGeometries(m, geom);
        this.mesh = m;
        this.mesh.updateCounts();
        this.mesh.updateBound();
        return l;
    }

    public List<BatchedGeometry> batch(Geometry ... geoms) {
        this.tmpList.clear();
        Mesh m = new Mesh();
        if (this.mesh != null) {
            this.tmpList.add(this);
        }
        for (Geometry geometry : geoms) {
            this.tmpList.add(geometry);
        }
        List<BatchedGeometry> l = this.mergeGeometries(m, this.tmpList);
        this.mesh = m;
        this.mesh.updateCounts();
        this.mesh.updateBound();
        return l;
    }

    @Override
    public void updateGeometricState() {
        if ((this.refreshFlags & 4) != 0) {
            this.updateWorldLightList();
        }
        if ((this.refreshFlags & 1) != 0) {
            this.updateWorldTransforms();
        }
        if (!this.children.isEmpty()) {
            for (BatchedGeometry child : this.children.getArray()) {
                child.updateGeometricState();
            }
            if (this.needMeshUpdate) {
                this.updateModelBound();
                this.needMeshUpdate = false;
            }
        }
        if ((this.refreshFlags & 2) != 0) {
            this.updateWorldBound();
        }
        assert (this.refreshFlags == 0);
    }

    protected void updateSubBatch(BatchedGeometry bg) {
        FloatBuffer buf = (FloatBuffer)this.mesh.getBuffer(VertexBuffer.Type.Position).getData();
        this.doTransformVerts(buf, 0, bg.startIndex, bg.startIndex + bg.getVertexCount(), buf, bg.cachedOffsetMat);
        this.mesh.getBuffer(VertexBuffer.Type.Position).updateData(buf);
        buf = (FloatBuffer)this.mesh.getBuffer(VertexBuffer.Type.Normal).getData();
        this.doTransformNorm(buf, 0, bg.startIndex, bg.startIndex + bg.getVertexCount(), buf, bg.cachedOffsetMat);
        this.mesh.getBuffer(VertexBuffer.Type.Normal).updateData(buf);
        if (this.mesh.getBuffer(VertexBuffer.Type.Tangent) != null) {
            buf = (FloatBuffer)this.mesh.getBuffer(VertexBuffer.Type.Tangent).getData();
            this.doTransformNorm(buf, 0, bg.startIndex, bg.startIndex + bg.getVertexCount(), buf, bg.cachedOffsetMat);
            this.mesh.getBuffer(VertexBuffer.Type.Tangent).updateData(buf);
        }
        this.needMeshUpdate = true;
    }

    public Spatial getChild(String name) {
        if (name == null) {
            return null;
        }
        for (BatchedGeometry child : this.children.getArray()) {
            Spatial out;
            if (name.equals(child.getName())) {
                return child;
            }
            if (!(child instanceof Node) || (out = ((Node)((Object)child)).getChild(name)) == null) continue;
            return out;
        }
        return null;
    }

    private List<BatchedGeometry> mergeGeometries(Mesh outMesh, List<Geometry> geometries) {
        int[] compsForBuf = new int[VertexBuffer.Type.values().length];
        VertexBuffer.Format[] formatForBuf = new VertexBuffer.Format[compsForBuf.length];
        ArrayList<BatchedGeometry> batchedGeoms = new ArrayList<BatchedGeometry>();
        int totalVerts = 0;
        int totalTris = 0;
        int totalLodLevels = 0;
        Mesh.Mode mode = null;
        for (Geometry geom : geometries) {
            int components;
            Mesh.Mode listMode;
            totalVerts += geom.getVertexCount();
            totalTris += geom.getTriangleCount();
            totalLodLevels = Math.min(totalLodLevels, geom.getMesh().getNumLodLevels());
            switch (geom.getMesh().getMode()) {
                case Points: {
                    listMode = Mesh.Mode.Points;
                    components = 1;
                    break;
                }
                case LineLoop: 
                case LineStrip: 
                case Lines: {
                    listMode = Mesh.Mode.Lines;
                    components = 2;
                    break;
                }
                case TriangleFan: 
                case TriangleStrip: 
                case Triangles: {
                    listMode = Mesh.Mode.Triangles;
                    components = 3;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            for (IntMap.Entry<VertexBuffer> entry : geom.getMesh().getBuffers()) {
                compsForBuf[entry.getKey()] = entry.getValue().getNumComponents();
                formatForBuf[entry.getKey()] = entry.getValue().getFormat();
            }
            if (mode != null && mode != listMode) {
                throw new UnsupportedOperationException("Cannot combine different primitive types: " + (Object)((Object)mode) + " != " + (Object)((Object)listMode));
            }
            mode = listMode;
            compsForBuf[VertexBuffer.Type.Index.ordinal()] = components;
        }
        outMesh.setMode(mode);
        formatForBuf[VertexBuffer.Type.Index.ordinal()] = totalVerts >= 65536 ? VertexBuffer.Format.UnsignedInt : VertexBuffer.Format.UnsignedShort;
        for (int i = 0; i < compsForBuf.length; ++i) {
            if (compsForBuf[i] == 0) continue;
            Buffer data = i == VertexBuffer.Type.Index.ordinal() ? VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalTris) : VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalVerts);
            VertexBuffer vb = new VertexBuffer(VertexBuffer.Type.values()[i]);
            vb.setupData(VertexBuffer.Usage.Static, compsForBuf[i], formatForBuf[i], data);
            outMesh.setBuffer(vb);
        }
        int globalVertIndex = 0;
        int globalTriIndex = 0;
        for (Geometry geom : geometries) {
            if (geom != this) {
                BatchedGeometry bg = new BatchedGeometry(this, geom);
                bg.startIndex = globalVertIndex;
                bg.setLocalTransform(geom.getLocalTransform());
                this.children.add(bg);
                batchedGeoms.add(bg);
            }
            Mesh inMesh = geom.getMesh();
            int n = inMesh.getVertexCount();
            int geomTriCount = inMesh.getTriangleCount();
            for (int bufType = 0; bufType < compsForBuf.length; ++bufType) {
                FloatBuffer outPos;
                VertexBuffer inBuf = inMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                VertexBuffer outBuf = outMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                if (outBuf == null) continue;
                if (VertexBuffer.Type.Index.ordinal() == bufType) {
                    int components = compsForBuf[bufType];
                    IndexBuffer inIdx = inMesh.getIndicesAsList();
                    IndexBuffer outIdx = outMesh.getIndexBuffer();
                    for (int tri = 0; tri < geomTriCount; ++tri) {
                        for (int comp = 0; comp < components; ++comp) {
                            int idx = inIdx.get(tri * components + comp) + globalVertIndex;
                            outIdx.put((globalTriIndex + tri) * components + comp, idx);
                        }
                    }
                    continue;
                }
                if (VertexBuffer.Type.Position.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getData();
                    outPos = (FloatBuffer)outBuf.getData();
                    this.doCopyBuffer(inPos, globalVertIndex, outPos);
                    continue;
                }
                if (VertexBuffer.Type.Normal.ordinal() == bufType || VertexBuffer.Type.Tangent.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getData();
                    outPos = (FloatBuffer)outBuf.getData();
                    this.doCopyBuffer(inPos, globalVertIndex, outPos);
                    continue;
                }
                for (int vert = 0; vert < n; ++vert) {
                    int curGlobalVertIndex = globalVertIndex + vert;
                    inBuf.copyElement(vert, outBuf, curGlobalVertIndex);
                }
            }
            globalVertIndex += n;
            globalTriIndex += geomTriCount;
        }
        return batchedGeoms;
    }

    private void doTransformVerts(FloatBuffer inBuf, int offset, int start, int end, FloatBuffer outBuf, Matrix4f transform) {
        TempVars vars = TempVars.get();
        Vector3f pos = vars.vect1;
        offset *= 3;
        for (int i = start; i < end; ++i) {
            pos.x = inBuf.get(i * 3 + 0);
            pos.y = inBuf.get(i * 3 + 1);
            pos.z = inBuf.get(i * 3 + 2);
            transform.mult(pos, pos);
            outBuf.put(offset + i * 3 + 0, pos.x);
            outBuf.put(offset + i * 3 + 1, pos.y);
            outBuf.put(offset + i * 3 + 2, pos.z);
        }
        vars.release();
    }

    private void doTransformNorm(FloatBuffer inBuf, int offset, int start, int end, FloatBuffer outBuf, Matrix4f transform) {
        TempVars vars = TempVars.get();
        Vector3f pos = vars.vect1;
        offset *= 3;
        for (int i = start; i < end; ++i) {
            pos.x = inBuf.get(i * 3 + 0);
            pos.y = inBuf.get(i * 3 + 1);
            pos.z = inBuf.get(i * 3 + 2);
            transform.multNormal(pos, pos);
            outBuf.put(offset + i * 3 + 0, pos.x);
            outBuf.put(offset + i * 3 + 1, pos.y);
            outBuf.put(offset + i * 3 + 2, pos.z);
        }
        vars.release();
    }

    private void doCopyBuffer(FloatBuffer inBuf, int offset, FloatBuffer outBuf) {
        TempVars vars = TempVars.get();
        Vector3f pos = vars.vect1;
        offset *= 3;
        for (int i = 0; i < inBuf.capacity() / 3; ++i) {
            pos.x = inBuf.get(i * 3 + 0);
            pos.y = inBuf.get(i * 3 + 1);
            pos.z = inBuf.get(i * 3 + 2);
            outBuf.put(offset + i * 3 + 0, pos.x);
            outBuf.put(offset + i * 3 + 1, pos.y);
            outBuf.put(offset + i * 3 + 2, pos.z);
        }
        vars.release();
    }

    public class ControlUpdate
    extends AbstractControl {
        protected void controlUpdate(float tpf) {
            for (BatchedGeometry batchedGeometry : GeometryBatch.this.children) {
                for (int i = 0; i < batchedGeometry.getNumControls(); ++i) {
                    batchedGeometry.getControl(i).update(tpf);
                }
            }
        }

        protected void controlRender(RenderManager rm, ViewPort vp) {
            for (BatchedGeometry batchedGeometry : GeometryBatch.this.children) {
                for (int i = 0; i < batchedGeometry.getNumControls(); ++i) {
                    batchedGeometry.getControl(i).render(rm, vp);
                }
            }
        }

        public Control cloneForSpatial(Spatial spatial) {
            return null;
        }
    }
}

