/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.android;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.jme3.app.AndroidHarness;
import com.jme3.asset.DesktopAssetManager;
import com.jme3.math.FastMath;
import com.jme3.system.JmeSystem;
import com.jme3.texture.Image;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class TextureUtil {
    public static int convertTextureFormat(Image.Format fmt) {
        switch (fmt) {
            case Alpha16: 
            case Alpha8: {
                return 6406;
            }
            case Luminance8Alpha8: 
            case Luminance16Alpha16: {
                return 6410;
            }
            case Luminance8: 
            case Luminance16: {
                return 6409;
            }
            case RGB10: 
            case RGB16: 
            case BGR8: 
            case RGB8: 
            case RGB565: {
                return 6407;
            }
            case RGB5A1: 
            case RGBA16: 
            case RGBA8: {
                return 6408;
            }
            case Depth: {
                return 6402;
            }
            case Depth16: {
                return 33189;
            }
            case Depth24: 
            case Depth32: 
            case Depth32F: {
                throw new UnsupportedOperationException("Unsupported depth format: " + (Object)((Object)fmt));
            }
            case DXT1A: {
                throw new UnsupportedOperationException("Unsupported format: " + (Object)((Object)fmt));
            }
        }
        throw new UnsupportedOperationException("Unrecognized format: " + (Object)((Object)fmt));
    }

    private static void buildMipmap(Bitmap bitmap) {
        int level = 0;
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        while (height >= 1 || width >= 1) {
            GLUtils.texImage2D((int)3553, (int)level, (Bitmap)bitmap, (int)0);
            if (height == 1 || width == 1) break;
            ++level;
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)(width /= 2), (int)(height /= 2), (boolean)true);
            bitmap.recycle();
            bitmap = bitmap2;
        }
    }

    public static void uploadTextureBitmap(int target, Bitmap bitmap, boolean generateMips, boolean powerOf2) {
        int MAX_RETRY_COUNT = 1;
        for (int retryCount = 0; retryCount < MAX_RETRY_COUNT; ++retryCount) {
            try {
                TextureUtil.uploadTextureBitmap2(target, bitmap, generateMips, powerOf2);
                continue;
            }
            catch (OutOfMemoryError ex) {
                if (retryCount >= MAX_RETRY_COUNT) {
                    throw ex;
                }
                DesktopAssetManager assetManager = (DesktopAssetManager)((AndroidHarness)JmeSystem.getActivity()).getJmeApplication().getAssetManager();
                assetManager.clearCache();
                System.gc();
                System.runFinalization();
            }
        }
    }

    private static void uploadTextureBitmap2(int target, Bitmap bitmap, boolean generateMips, boolean powerOf2) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("bitmap is recycled.");
        }
        if (!powerOf2) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (!FastMath.isPowerOfTwo(width) || !FastMath.isPowerOfTwo(height)) {
                width = FastMath.nearestPowerOfTwo(width);
                height = FastMath.nearestPowerOfTwo(height);
                Logger.getLogger(TextureUtil.class.getName()).warning("texture size changed.");
                Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
                bitmap.recycle();
                bitmap = bitmap2;
            }
        }
        if (generateMips) {
            TextureUtil.buildMipmap(bitmap);
        } else {
            GLUtils.texImage2D((int)target, (int)0, (Bitmap)bitmap, (int)0);
        }
    }

    public static void uploadTexture(Image img, int target, int index, int border, boolean tdc, boolean generateMips, boolean powerOf2) {
        if (img.getEfficentData() instanceof Bitmap) {
            Bitmap bitmap = (Bitmap)img.getEfficentData();
            TextureUtil.uploadTextureBitmap(target, bitmap, generateMips, powerOf2);
            return;
        }
        Image.Format fmt = img.getFormat();
        ByteBuffer data = index >= 0 || img.getData() != null && img.getData().size() > 0 ? img.getData(index) : null;
        int width = img.getWidth();
        int height = img.getHeight();
        int depth = img.getDepth();
        boolean compress = false;
        int internalFormat = -1;
        int format = -1;
        int dataType = -1;
        switch (fmt) {
            case Alpha16: 
            case Alpha8: {
                format = 6406;
                dataType = 5121;
                break;
            }
            case Luminance8: {
                format = 6409;
                dataType = 5121;
                break;
            }
            case Luminance8Alpha8: {
                format = 6410;
                dataType = 5121;
                break;
            }
            case Luminance16Alpha16: {
                format = 6410;
                dataType = 5121;
                break;
            }
            case Luminance16: {
                format = 6409;
                dataType = 5121;
                break;
            }
            case RGB565: {
                format = 6407;
                internalFormat = 36194;
                dataType = 33635;
                break;
            }
            case ARGB4444: {
                format = 6408;
                dataType = 32819;
                break;
            }
            case RGB10: {
                format = 6407;
                dataType = 5121;
                break;
            }
            case RGB16: {
                format = 6407;
                dataType = 5121;
                break;
            }
            case RGB5A1: {
                format = 6408;
                internalFormat = 32855;
                dataType = 32820;
                break;
            }
            case RGB8: {
                format = 6407;
                dataType = 5121;
                break;
            }
            case BGR8: {
                format = 6407;
                dataType = 5121;
                break;
            }
            case RGBA16: {
                format = 6408;
                internalFormat = 32854;
                dataType = 5121;
                break;
            }
            case RGBA8: {
                format = 6408;
                dataType = 5121;
                break;
            }
            case DXT1A: {
                format = 34467;
                dataType = 5121;
            }
            case Depth: {
                format = 6402;
                dataType = 5121;
                break;
            }
            case Depth16: {
                format = 6402;
                internalFormat = 33189;
                dataType = 5121;
                break;
            }
            case Depth24: 
            case Depth32: 
            case Depth32F: {
                throw new UnsupportedOperationException("Unsupported depth format: " + (Object)((Object)fmt));
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized format: " + (Object)((Object)fmt));
            }
        }
        if (internalFormat == -1) {
            internalFormat = format;
        }
        if (data != null) {
            GLES20.glPixelStorei((int)3317, (int)1);
        }
        int[] mipSizes = img.getMipMapSizes();
        int pos = 0;
        if (mipSizes == null) {
            mipSizes = data != null ? new int[]{data.capacity()} : new int[]{width * height * fmt.getBitsPerPixel() / 8};
        }
        if (compress) {
            data.clear();
            GLES20.glCompressedTexImage2D((int)3553, (int)(1 - mipSizes.length), (int)format, (int)width, (int)height, (int)0, (int)data.capacity(), (Buffer)data);
            return;
        }
        for (int i = 0; i < mipSizes.length; ++i) {
            int mipWidth = Math.max(1, width >> i);
            int mipHeight = Math.max(1, height >> i);
            int mipDepth = Math.max(1, depth >> i);
            if (data != null) {
                data.position(pos);
                data.limit(pos + mipSizes[i]);
            }
            if (compress && data != null) {
                GLES20.glCompressedTexImage2D((int)3553, (int)i, (int)format, (int)mipWidth, (int)mipHeight, (int)0, (int)data.remaining(), (Buffer)data);
            } else {
                GLES20.glTexImage2D((int)3553, (int)i, (int)internalFormat, (int)mipWidth, (int)mipHeight, (int)0, (int)format, (int)dataType, (Buffer)data);
            }
            pos += mipSizes[i];
        }
    }
}

