/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.renderer.Renderer;

public abstract class GLObject
implements Cloneable {
    protected int id = -1;
    protected Object handleRef = null;
    protected boolean updateNeeded = true;
    protected final Type type;

    public GLObject(Type type) {
        this.type = type;
        this.handleRef = new Object();
    }

    protected GLObject(Type type, int id2) {
        this.type = type;
        this.id = id2;
    }

    public void setId(int id2) {
        if (this.id != -1) {
            throw new IllegalStateException("ID has already been set for this GL object.");
        }
        this.id = id2;
    }

    public int getId() {
        return this.id;
    }

    public void setUpdateNeeded() {
        this.updateNeeded = true;
    }

    public void clearUpdateNeeded() {
        this.updateNeeded = false;
    }

    public boolean isUpdateNeeded() {
        return this.updateNeeded;
    }

    public String toString() {
        return this.type.name() + " " + Integer.toHexString(this.hashCode());
    }

    protected GLObject clone() {
        try {
            GLObject obj = (GLObject)super.clone();
            obj.handleRef = new Object();
            obj.id = -1;
            obj.updateNeeded = true;
            return obj;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public abstract void resetObject();

    public abstract void deleteObject(Renderer var1);

    public abstract GLObject createDestructableClone();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        Texture,
        VertexBuffer,
        ShaderSource,
        Shader,
        FrameBuffer;

    }
}

