/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.Asset;
import com.jme3.asset.AssetKey;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.WeakHashMap;

public class AssetCache {
    private final WeakHashMap<AssetKey, SmartAssetInfo> smartCache = new WeakHashMap();
    private final HashMap<AssetKey, Object> regularCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(AssetKey key, Object obj) {
        HashMap<AssetKey, Object> hashMap = this.regularCache;
        synchronized (hashMap) {
            if (obj instanceof Asset && key.useSmartCache()) {
                Asset asset = (Asset)obj;
                asset.setKey(null);
                SmartAssetInfo smartInfo = new SmartAssetInfo();
                smartInfo.asset = asset;
                smartInfo.smartKey = new WeakReference<AssetKey>(key);
                this.smartCache.put(key, smartInfo);
            } else {
                this.regularCache.put(key, obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFromCache(AssetKey key) {
        HashMap<AssetKey, Object> hashMap = this.regularCache;
        synchronized (hashMap) {
            if (key.useSmartCache()) {
                return this.smartCache.remove(key) != null;
            }
            return this.regularCache.remove(key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromCache(AssetKey key) {
        HashMap<AssetKey, Object> hashMap = this.regularCache;
        synchronized (hashMap) {
            if (key.useSmartCache()) {
                return this.smartCache.get((Object)key).asset;
            }
            return this.regularCache.get(key);
        }
    }

    public SmartAssetInfo getFromSmartCache(AssetKey key) {
        return this.smartCache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllAssets() {
        HashMap<AssetKey, Object> hashMap = this.regularCache;
        synchronized (hashMap) {
            this.regularCache.clear();
            this.smartCache.clear();
        }
    }

    public static final class SmartAssetInfo {
        public WeakReference<AssetKey> smartKey;
        public Asset asset;
    }
}

