/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class SkeletonControl
extends AbstractControl
implements Cloneable {
    private Skeleton skeleton;
    private Mesh[] targets;
    private boolean wasMeshUpdated = false;

    public SkeletonControl() {
    }

    public SkeletonControl(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    @Deprecated
    SkeletonControl(Mesh[] targets, Skeleton skeleton) {
        this.skeleton = skeleton;
        this.targets = targets;
    }

    private boolean isMeshAnimated(Mesh mesh) {
        return mesh.getBuffer(VertexBuffer.Type.BindPosePosition) != null;
    }

    private Mesh[] findTargets(Node node) {
        Mesh sharedMesh = null;
        ArrayList<Mesh> animatedMeshes = new ArrayList<Mesh>();
        for (Spatial child : node.getChildren()) {
            if (!(child instanceof Geometry)) continue;
            Geometry geom = (Geometry)child;
            Mesh childSharedMesh = (Mesh)geom.getUserData("JmeSharedMesh");
            if (childSharedMesh != null) {
                if (!this.isMeshAnimated(childSharedMesh)) continue;
                if (sharedMesh == null) {
                    sharedMesh = childSharedMesh;
                    continue;
                }
                if (sharedMesh == childSharedMesh) continue;
                throw new IllegalStateException("Two conflicting shared meshes for " + node);
            }
            Mesh mesh = geom.getMesh();
            if (!this.isMeshAnimated(mesh)) continue;
            animatedMeshes.add(mesh);
        }
        if (sharedMesh != null) {
            animatedMeshes.add(sharedMesh);
        }
        return animatedMeshes.toArray(new Mesh[animatedMeshes.size()]);
    }

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        if (spatial != null) {
            Node node = (Node)spatial;
            this.targets = this.findTargets(node);
        } else {
            this.targets = null;
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
        if (!this.wasMeshUpdated) {
            this.resetToBind();
            Matrix4f[] offsetMatrices = this.skeleton.computeSkinningMatrices();
            for (int i = 0; i < this.targets.length; ++i) {
                this.softwareSkinUpdate(this.targets[i], offsetMatrices);
            }
            this.wasMeshUpdated = true;
        }
    }

    protected void controlUpdate(float tpf) {
        this.wasMeshUpdated = false;
    }

    void resetToBind() {
        for (Mesh mesh : this.targets) {
            if (!this.isMeshAnimated(mesh)) continue;
            VertexBuffer bi = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
            ByteBuffer bib = (ByteBuffer)bi.getData();
            if (!bib.hasArray()) {
                mesh.prepareForAnim(true);
            }
            VertexBuffer bindPos = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
            VertexBuffer bindNorm = mesh.getBuffer(VertexBuffer.Type.BindPoseNormal);
            VertexBuffer pos = mesh.getBuffer(VertexBuffer.Type.Position);
            VertexBuffer norm = mesh.getBuffer(VertexBuffer.Type.Normal);
            FloatBuffer pb = (FloatBuffer)pos.getData();
            FloatBuffer nb = (FloatBuffer)norm.getData();
            FloatBuffer bpb = (FloatBuffer)bindPos.getData();
            FloatBuffer bnb = (FloatBuffer)bindNorm.getData();
            pb.clear();
            nb.clear();
            bpb.clear();
            bnb.clear();
            pb.put(bpb).clear();
            nb.put(bnb).clear();
        }
    }

    public Control cloneForSpatial(Spatial spatial) {
        Node clonedNode = (Node)spatial;
        AnimControl ctrl = spatial.getControl(AnimControl.class);
        SkeletonControl clone = new SkeletonControl();
        clone.setSpatial(clonedNode);
        clone.skeleton = ctrl.getSkeleton();
        clone.targets = this.findTargets(clonedNode);
        for (int i = 0; i < clonedNode.getQuantity(); ++i) {
            Node clonedAttachNode;
            Bone originalBone;
            Spatial child = clonedNode.getChild(i);
            if (!(child instanceof Node) || (originalBone = (Bone)(clonedAttachNode = (Node)child).getUserData("AttachedBone")) == null) continue;
            Bone clonedBone = clone.skeleton.getBone(originalBone.getName());
            clonedAttachNode.setUserData("AttachedBone", clonedBone);
            clonedBone.setAttachmentsNode(clonedAttachNode);
        }
        return clone;
    }

    public Node getAttachmentsNode(String boneName) {
        Bone b = this.skeleton.getBone(boneName);
        if (b == null) {
            throw new IllegalArgumentException("Given bone name does not exist in the skeleton.");
        }
        Node n = b.getAttachmentsNode();
        Node model = (Node)this.spatial;
        model.attachChild(n);
        return n;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public Mesh[] getTargets() {
        return this.targets;
    }

    private void softwareSkinUpdate(Mesh mesh, Matrix4f[] offsetMatrices) {
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            throw new IllegalStateException("Max weights per vert is incorrectly set!");
        }
        int fourMinusMaxWeights = 4 - maxWeightsPerVert;
        VertexBuffer vb = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        fvb.rewind();
        VertexBuffer nb = mesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer fnb = (FloatBuffer)nb.getData();
        fnb.rewind();
        ByteBuffer ib = (ByteBuffer)mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData();
        FloatBuffer wb = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        ib.rewind();
        wb.rewind();
        float[] weights = wb.array();
        byte[] indices = ib.array();
        int idxWeights = 0;
        TempVars vars = TempVars.get();
        float[] posBuf = vars.skinPositions;
        float[] normBuf = vars.skinNormals;
        int iterations = (int)FastMath.ceil((float)fvb.capacity() / (float)posBuf.length);
        int bufLength = posBuf.length * 3;
        for (int i = iterations - 1; i >= 0; --i) {
            bufLength = Math.min(posBuf.length, fvb.remaining());
            fvb.get(posBuf, 0, bufLength);
            fnb.get(normBuf, 0, bufLength);
            int verts = bufLength / 3;
            int idxPositions = 0;
            for (int vert = verts - 1; vert >= 0; --vert) {
                float nmx = normBuf[idxPositions];
                float vtx = posBuf[idxPositions++];
                float nmy = normBuf[idxPositions];
                float vty = posBuf[idxPositions++];
                float nmz = normBuf[idxPositions];
                float vtz = posBuf[idxPositions++];
                float rx = 0.0f;
                float ry = 0.0f;
                float rz = 0.0f;
                float rnx = 0.0f;
                float rny = 0.0f;
                float rnz = 0.0f;
                for (int w = maxWeightsPerVert - 1; w >= 0; --w) {
                    float weight = weights[idxWeights];
                    Matrix4f mat = offsetMatrices[indices[idxWeights++]];
                    rx += (mat.m00 * vtx + mat.m01 * vty + mat.m02 * vtz + mat.m03) * weight;
                    ry += (mat.m10 * vtx + mat.m11 * vty + mat.m12 * vtz + mat.m13) * weight;
                    rz += (mat.m20 * vtx + mat.m21 * vty + mat.m22 * vtz + mat.m23) * weight;
                    rnx += (nmx * mat.m00 + nmy * mat.m01 + nmz * mat.m02) * weight;
                    rny += (nmx * mat.m10 + nmy * mat.m11 + nmz * mat.m12) * weight;
                    rnz += (nmx * mat.m20 + nmy * mat.m21 + nmz * mat.m22) * weight;
                }
                idxWeights += fourMinusMaxWeights;
                normBuf[idxPositions -= 3] = rnx;
                posBuf[idxPositions++] = rx;
                normBuf[idxPositions] = rny;
                posBuf[idxPositions++] = ry;
                normBuf[idxPositions] = rnz;
                posBuf[idxPositions++] = rz;
            }
            fvb.position(fvb.position() - bufLength);
            fvb.put(posBuf, 0, bufLength);
            fnb.position(fnb.position() - bufLength);
            fnb.put(normBuf, 0, bufLength);
        }
        vars.release();
        vb.updateData(fvb);
        nb.updateData(fnb);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.targets, "targets", null);
        oc.write(this.skeleton, "skeleton", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule in = im.getCapsule(this);
        Savable[] sav = in.readSavableArray("targets", null);
        if (sav != null) {
            this.targets = new Mesh[sav.length];
            System.arraycopy(sav, 0, this.targets, 0, sav.length);
        }
        this.skeleton = (Skeleton)in.readSavable("skeleton", null);
    }
}

