/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file.util2;

import java.util.ArrayList;
import java.util.List;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.util2.MeshConverter;

public class MeshData {
    PMDModel model;
    int maxBoneSize;
    PMDMaterial material;
    List<Integer> boneList = new ArrayList<Integer>();
    List<Integer> indexList = new ArrayList<Integer>();
    List<Integer> vertIndexList = new ArrayList<Integer>();
    public int offset;
    private PMDVertex tmpVert = new PMDVertex();

    public MeshData(PMDModel model, int maxBoneSize, PMDMaterial material, int offset) {
        this.model = model;
        this.maxBoneSize = maxBoneSize;
        this.material = material;
        this.offset = offset;
    }

    public boolean addTriangle(MeshConverter mc, int i1, int i2, int i3) {
        int boneListSizeBefore = this.boneList.size();
        this.addBoneList(i1);
        this.addBoneList(i2);
        this.addBoneList(i3);
        if (this.boneList.size() <= this.maxBoneSize) {
            this.addVertex(mc, i1);
            this.addVertex(mc, i2);
            this.addVertex(mc, i3);
            return true;
        }
        for (int i = this.boneList.size(); i > boneListSizeBefore; --i) {
            this.boneList.remove(i - 1);
        }
        return false;
    }

    private void addBoneList(int vertIndex) {
        PMDVertex v = this.model.getVertex(vertIndex, this.tmpVert);
        if (v.getBoneWeight() != 0 && !this.boneList.contains(v.getBoneNum1())) {
            this.boneList.add(v.getBoneNum1());
        }
        if (v.getBoneWeight() != 100 && !this.boneList.contains(v.getBoneNum2())) {
            this.boneList.add(v.getBoneNum2());
        }
    }

    private void addVertex(MeshConverter mc, int vertIndex) {
        int newVertIndex;
        Integer index = mc.meshTmpVertMap.get(vertIndex);
        if (index != null) {
            newVertIndex = index;
        } else {
            newVertIndex = this.vertIndexList.size();
            this.vertIndexList.add(vertIndex);
            mc.meshTmpVertMap.put(vertIndex, newVertIndex);
        }
        this.indexList.add(newVertIndex);
    }

    public List<Integer> getBoneList() {
        return this.boneList;
    }

    public void setBoneList(List<Integer> boneList) {
        this.boneList = boneList;
    }

    public PMDMaterial getMaterial() {
        return this.material;
    }

    public void setMaterial(PMDMaterial material) {
        this.material = material;
    }

    public int getMaxBoneSize() {
        return this.maxBoneSize;
    }

    public void setMaxBoneSize(int maxBoneSize) {
        this.maxBoneSize = maxBoneSize;
    }

    public PMDModel getModel() {
        return this.model;
    }

    public void setModel(PMDModel model) {
        this.model = model;
    }

    public List<Integer> getVertIndexList() {
        return this.vertIndexList;
    }

    public List<Integer> getIndexList() {
        return this.indexList;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MeshData other = (MeshData)obj;
        return this == obj;
    }
}

