/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import java.io.Serializable;
import javax.vecmath.Vector3f;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;

public class PMDRigidBody
implements Serializable {
    private String rigidBodyName;
    private int relBoneIndex;
    private int rigidBodyGroupIndex;
    private int rigidBodyGroupTarget;
    private int shapeType;
    private float shapeW;
    private float shapeH;
    private float shapeD;
    private Vector3f pos;
    private Vector3f rot;
    private float weight;
    private float posDim;
    private float rotDim;
    private float recoil;
    private float friction;
    private int rigidBodyType;

    public PMDRigidBody(DataInputStreamLittleEndian is) throws IOException {
        this.rigidBodyName = is.readString(20);
        this.relBoneIndex = is.readUnsignedShort();
        this.rigidBodyGroupIndex = is.readUnsignedByte();
        this.rigidBodyGroupTarget = is.readUnsignedShort();
        this.shapeType = is.readUnsignedByte();
        this.shapeW = is.readFloat();
        this.shapeH = is.readFloat();
        this.shapeD = is.readFloat();
        this.pos = new Vector3f(is.readFloat(), is.readFloat(), -is.readFloat());
        this.rot = new Vector3f(-is.readFloat(), -is.readFloat(), is.readFloat());
        this.weight = is.readFloat();
        this.posDim = is.readFloat();
        this.rotDim = is.readFloat();
        this.recoil = is.readFloat();
        this.friction = is.readFloat();
        this.rigidBodyType = is.readUnsignedByte();
    }

    public String toString() {
        return "PMDRigidBody{rigidBodyName=" + this.rigidBodyName + ", relBoneIndex=" + this.relBoneIndex + ", rigidBodyGroupIndex=" + this.rigidBodyGroupIndex + ", rigidBodyGroupTarget=" + this.rigidBodyGroupTarget + ", shapeType=" + this.shapeType + ", shapeW=" + this.shapeW + ", shapeH=" + this.shapeH + ", shapeD=" + this.shapeD + ", pos=" + this.pos + ", rot=" + this.rot + ", weight=" + this.weight + ", posDim=" + this.posDim + ", rotDim=" + this.rotDim + ", recoil=" + this.recoil + ", friction=" + this.friction + ", rigidBodyType=" + this.rigidBodyType + '}';
    }

    public float getFriction() {
        return this.friction;
    }

    public void setFriction(float friction) {
        this.friction = friction;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public void setPos(Vector3f pos) {
        this.pos = pos;
    }

    public float getPosDim() {
        return this.posDim;
    }

    public void setPosDim(float posDim) {
        this.posDim = posDim;
    }

    public float getRecoil() {
        return this.recoil;
    }

    public void setRecoil(float recoil) {
        this.recoil = recoil;
    }

    public int getRelBoneIndex() {
        return this.relBoneIndex;
    }

    public void setRelBoneIndex(int relBoneIndex) {
        this.relBoneIndex = relBoneIndex;
    }

    public int getRigidBodyGroupIndex() {
        return this.rigidBodyGroupIndex;
    }

    public void setRigidBodyGroupIndex(int rigidBodyGroupIndex) {
        this.rigidBodyGroupIndex = rigidBodyGroupIndex;
    }

    public int getRigidBodyGroupTarget() {
        return this.rigidBodyGroupTarget;
    }

    public void setRigidBodyGroupTarget(int rigidBodyGroupTarget) {
        this.rigidBodyGroupTarget = rigidBodyGroupTarget;
    }

    public String getRigidBodyName() {
        return this.rigidBodyName;
    }

    public void setRigidBodyName(String rigidBodyName) {
        this.rigidBodyName = rigidBodyName;
    }

    public int getRigidBodyType() {
        return this.rigidBodyType;
    }

    public void setRigidBodyType(int rigidBodyType) {
        this.rigidBodyType = rigidBodyType;
    }

    public Vector3f getRot() {
        return this.rot;
    }

    public void setRot(Vector3f rot) {
        this.rot = rot;
    }

    public float getRotDim() {
        return this.rotDim;
    }

    public void setRotDim(float rotDim) {
        this.rotDim = rotDim;
    }

    public float getShapeD() {
        return this.shapeD;
    }

    public void setShapeD(float shapeD) {
        this.shapeD = shapeD;
    }

    public float getShapeH() {
        return this.shapeH;
    }

    public void setShapeH(float shapeH) {
        this.shapeH = shapeH;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(int shapeType) {
        this.shapeType = shapeType;
    }

    public float getShapeW() {
        return this.shapeW;
    }

    public void setShapeW(float shapeW) {
        this.shapeW = shapeW;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }
}

