/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import java.io.Serializable;
import javax.vecmath.Vector3f;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;

public class PMDJoint
implements Serializable {
    private String jointName;
    private int rigidBodyA;
    private int rigidBodyB;
    private Vector3f jointPos;
    private Vector3f jointRot;
    private Vector3f constPos1;
    private Vector3f constPos2;
    private Vector3f constRot1;
    private Vector3f constRot2;
    float[] stiffness = new float[6];

    static void swapConst(Vector3f v1, Vector3f v2) {
        float tmp = v1.x;
        v1.x = v2.x;
        v2.x = tmp;
        tmp = v1.y;
        v1.y = v2.y;
        v2.y = tmp;
    }

    static void swapConst2(Vector3f v1) {
    }

    public PMDJoint(DataInputStreamLittleEndian is) throws IOException {
        this.jointName = is.readString(20);
        this.rigidBodyA = is.readInt();
        this.rigidBodyB = is.readInt();
        this.jointPos = new Vector3f(is.readFloat(), is.readFloat(), -is.readFloat());
        this.jointRot = new Vector3f(-is.readFloat(), -is.readFloat(), is.readFloat());
        this.constPos1 = new Vector3f(is.readFloat(), is.readFloat(), -is.readFloat());
        this.constPos2 = new Vector3f(is.readFloat(), is.readFloat(), -is.readFloat());
        this.constRot1 = new Vector3f(-is.readFloat(), -is.readFloat(), is.readFloat());
        this.constRot2 = new Vector3f(-is.readFloat(), -is.readFloat(), is.readFloat());
        float tmp = this.constPos1.z;
        this.constPos1.z = this.constPos2.z;
        this.constPos2.z = tmp;
        PMDJoint.swapConst(this.constRot1, this.constRot2);
        for (int i = 0; i < 6; ++i) {
            this.stiffness[i] = is.readFloat();
        }
    }

    public String toString() {
        return "PMDJoint{jointName=" + this.jointName + ", rigidBodyA=" + this.rigidBodyA + ", rigidBodyB=" + this.rigidBodyB + ", jointPos=" + this.jointPos + ", jointRot=" + this.jointRot + ", constPos1=" + this.constPos1 + ", constPos2=" + this.constPos2 + ", constRot1=" + this.constRot1 + ", constRot2=" + this.constRot2 + ", stiffness=" + this.stiffness + '}';
    }

    public Vector3f getConstPos1() {
        return this.constPos1;
    }

    public void setConstPos1(Vector3f constPos1) {
        this.constPos1 = constPos1;
    }

    public Vector3f getConstPos2() {
        return this.constPos2;
    }

    public void setConstPos2(Vector3f constPos2) {
        this.constPos2 = constPos2;
    }

    public Vector3f getConstRot1() {
        return this.constRot1;
    }

    public void setConstRot1(Vector3f constRot1) {
        this.constRot1 = constRot1;
    }

    public Vector3f getConstRot2() {
        return this.constRot2;
    }

    public void setConstRot2(Vector3f constRot2) {
        this.constRot2 = constRot2;
    }

    public String getJointName() {
        return this.jointName;
    }

    public void setJointName(String jointName) {
        this.jointName = jointName;
    }

    public Vector3f getJointPos() {
        return this.jointPos;
    }

    public void setJointPos(Vector3f jointPos) {
        this.jointPos = jointPos;
    }

    public Vector3f getJointRot() {
        return this.jointRot;
    }

    public void setJointRot(Vector3f jointRot) {
        this.jointRot = jointRot;
    }

    public int getRigidBodyA() {
        return this.rigidBodyA;
    }

    public void setRigidBodyA(int rigidBodyA) {
        this.rigidBodyA = rigidBodyA;
    }

    public int getRigidBodyB() {
        return this.rigidBodyB;
    }

    public void setRigidBodyB(int rigidBodyB) {
        this.rigidBodyB = rigidBodyB;
    }

    public float[] getStiffness() {
        return this.stiffness;
    }

    public void setStiffness(float[] stiffness) {
        this.stiffness = stiffness;
    }
}

