/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.io.IOException;
import projectkyoto.jme3.mmd.PMDMesh;
import projectkyoto.jme3.mmd.PMDSkinMesh;
import projectkyoto.mmd.file.PMDMaterial;

public class PMDGeometry
extends Geometry {
    PMDMaterial pmdMaterial;
    Material glslSkinningMaterial;
    Material noSkinningMaterial;

    public PMDGeometry(String name, Mesh mesh) {
        super(name, mesh);
    }

    public PMDGeometry(String name) {
        super(name);
    }

    public PMDGeometry() {
    }

    public PMDMaterial getPmdMaterial() {
        return this.pmdMaterial;
    }

    public void setPmdMaterial(PMDMaterial pmdMaterial) {
        this.pmdMaterial = pmdMaterial;
    }

    public Material getGlslSkinningMaterial() {
        return this.glslSkinningMaterial;
    }

    public void setGlslSkinningMaterial(Material glslSkinningMaterial) {
        this.glslSkinningMaterial = glslSkinningMaterial;
    }

    public Material getNoSkinningMaterial() {
        return this.noSkinningMaterial;
    }

    public void setNoSkinningMaterial(Material noSkinningMaterial) {
        this.noSkinningMaterial = noSkinningMaterial;
    }

    public PMDGeometry clone() {
        Mesh meshBackup = this.mesh;
        this.mesh = new Mesh();
        PMDGeometry newPMDGeometry = (PMDGeometry)super.clone(false);
        this.mesh = meshBackup;
        if (this.mesh instanceof PMDSkinMesh) {
            PMDSkinMesh oldMesh = (PMDSkinMesh)this.mesh;
            PMDSkinMesh newMesh = new PMDSkinMesh();
            newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.Position));
            newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.Normal));
            newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.BoneIndex));
            newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.BoneWeight));
            newMesh.boneIndexArray = oldMesh.boneIndexArray;
            newMesh.boneMatrixArray = new Matrix4f[oldMesh.boneMatrixArray.length];
            if (oldMesh.getBuffer(VertexBuffer.Type.TexCoord) != null) {
                newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.TexCoord));
            }
            newMesh.bound = oldMesh.bound.clone();
            newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.Index));
            newPMDGeometry.setMesh(newMesh);
        } else {
            PMDMesh oldMesh = (PMDMesh)this.mesh;
            PMDMesh newMesh = new PMDMesh();
            newMesh.boneIndexArray = oldMesh.boneIndexArray;
            newMesh.boneMatrixArray = new Matrix4f[oldMesh.boneMatrixArray.length];
            for (int i = 0; i < newMesh.boneMatrixArray.length; ++i) {
                newMesh.boneMatrixArray[i] = new Matrix4f();
                newMesh.boneMatrixArray[i].set(oldMesh.boneMatrixArray[i]);
            }
            newMesh.setMode(Mesh.Mode.Triangles);
            newMesh.setVbBackup(oldMesh.getVbBackup());
            newMesh.setNbBackup(oldMesh.getNbBackup());
            newMesh.setBuffer(oldMesh.getVbBackup());
            newMesh.setBuffer(oldMesh.getNbBackup());
            newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.Index));
            if (oldMesh.getBuffer(VertexBuffer.Type.TexCoord) != null) {
                newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.TexCoord));
            }
            newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.BoneIndex));
            newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.BoneWeight));
            if (oldMesh.getBuffer(VertexBuffer.Type.InterleavedData) != null) {
                newMesh.setBuffer(oldMesh.getBuffer(VertexBuffer.Type.InterleavedData));
            }
            newPMDGeometry.setMesh(newMesh);
        }
        newPMDGeometry.glslSkinningMaterial = this.glslSkinningMaterial.clone();
        newPMDGeometry.noSkinningMaterial = this.noSkinningMaterial.clone();
        return newPMDGeometry;
    }

    public PMDGeometry clone(boolean cloneMaterial) {
        return this.clone();
    }

    public void setMaterial(Material material) {
        super.setMaterial(material);
        if (this.mesh instanceof PMDMesh) {
            PMDMesh pmdMesh = (PMDMesh)this.mesh;
            pmdMesh.boneMatricesParamIndex = -1;
        }
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule c = im.getCapsule((Savable)this);
        this.glslSkinningMaterial = (Material)c.readSavable("glslSkinningMaterial", null);
        this.noSkinningMaterial = (Material)c.readSavable("noSkinningMaterial", null);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule c = ex.getCapsule((Savable)this);
        c.write((Savable)this.glslSkinningMaterial, "glslSkinningMaterial", null);
        c.write((Savable)this.noSkinningMaterial, "noSkinningMaterial", null);
    }
}

