/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsGhostObject
extends PhysicsCollisionObject {
    protected boolean locationDirty = false;
    protected final Quaternion tmp_inverseWorldRotation = new Quaternion();
    private List<PhysicsCollisionObject> overlappingObjects = new LinkedList<PhysicsCollisionObject>();

    public PhysicsGhostObject() {
    }

    public PhysicsGhostObject(CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
        this.buildObject();
    }

    public PhysicsGhostObject(Spatial spatial, CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
        this.buildObject();
    }

    protected void buildObject() {
        if (this.objectId == 0L) {
            this.objectId = this.createGhostObject();
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Ghost Object {0}", Long.toHexString(this.objectId));
            this.setGhostFlags(this.objectId);
            this.initUserPointer();
        }
        this.attachCollisionShape(this.objectId, this.collisionShape.getObjectId());
    }

    private native long createGhostObject();

    private native void setGhostFlags(long var1);

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        super.setCollisionShape(collisionShape);
        if (this.objectId == 0L) {
            this.buildObject();
        } else {
            this.attachCollisionShape(this.objectId, collisionShape.getObjectId());
        }
    }

    public void setPhysicsLocation(Vector3f vector3f) {
        this.setPhysicsLocation(this.objectId, vector3f);
    }

    private native void setPhysicsLocation(long var1, Vector3f var3);

    public void setPhysicsRotation(Matrix3f matrix3f) {
        this.setPhysicsRotation(this.objectId, matrix3f);
    }

    private native void setPhysicsRotation(long var1, Matrix3f var3);

    public void setPhysicsRotation(Quaternion quaternion) {
        this.setPhysicsRotation(this.objectId, quaternion);
    }

    private native void setPhysicsRotation(long var1, Quaternion var3);

    public Vector3f getPhysicsLocation(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        this.getPhysicsLocation(this.objectId, vector3f);
        return vector3f;
    }

    private native void getPhysicsLocation(long var1, Vector3f var3);

    public Quaternion getPhysicsRotation(Quaternion quaternion) {
        if (quaternion == null) {
            quaternion = new Quaternion();
        }
        this.getPhysicsRotation(this.objectId, quaternion);
        return quaternion;
    }

    private native void getPhysicsRotation(long var1, Quaternion var3);

    public Matrix3f getPhysicsRotationMatrix(Matrix3f matrix3f) {
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        this.getPhysicsRotationMatrix(this.objectId, matrix3f);
        return matrix3f;
    }

    private native void getPhysicsRotationMatrix(long var1, Matrix3f var3);

    public Vector3f getPhysicsLocation() {
        Vector3f vector3f = new Vector3f();
        this.getPhysicsLocation(this.objectId, vector3f);
        return vector3f;
    }

    public Quaternion getPhysicsRotation() {
        Quaternion quaternion = new Quaternion();
        this.getPhysicsRotation(this.objectId, quaternion);
        return quaternion;
    }

    public Matrix3f getPhysicsRotationMatrix() {
        Matrix3f matrix3f = new Matrix3f();
        this.getPhysicsRotationMatrix(this.objectId, matrix3f);
        return matrix3f;
    }

    public void destroy() {
    }

    public List<PhysicsCollisionObject> getOverlappingObjects() {
        this.overlappingObjects.clear();
        this.getOverlappingObjects(this.objectId);
        return this.overlappingObjects;
    }

    protected native void getOverlappingObjects(long var1);

    protected void addOverlappingObject(PhysicsCollisionObject physicsCollisionObject) {
        this.overlappingObjects.add(physicsCollisionObject);
    }

    public int getOverlappingCount() {
        return this.getOverlappingCount(this.objectId);
    }

    private native int getOverlappingCount(long var1);

    public PhysicsCollisionObject getOverlapping(int n) {
        return this.overlappingObjects.get(n);
    }

    public void setCcdSweptSphereRadius(float f) {
        this.setCcdSweptSphereRadius(this.objectId, f);
    }

    private native void setCcdSweptSphereRadius(long var1, float var3);

    public void setCcdMotionThreshold(float f) {
        this.setCcdMotionThreshold(this.objectId, f);
    }

    private native void setCcdMotionThreshold(long var1, float var3);

    public float getCcdSweptSphereRadius() {
        return this.getCcdSweptSphereRadius(this.objectId);
    }

    private native float getCcdSweptSphereRadius(long var1);

    public float getCcdMotionThreshold() {
        return this.getCcdMotionThreshold(this.objectId);
    }

    private native float getCcdMotionThreshold(long var1);

    public float getCcdSquareMotionThreshold() {
        return this.getCcdSquareMotionThreshold(this.objectId);
    }

    private native float getCcdSquareMotionThreshold(long var1);

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.getPhysicsLocation(new Vector3f()), "physicsLocation", (Savable)new Vector3f());
        outputCapsule.write((Savable)this.getPhysicsRotationMatrix(new Matrix3f()), "physicsRotation", (Savable)new Matrix3f());
        outputCapsule.write(this.getCcdMotionThreshold(), "ccdMotionThreshold", 0.0f);
        outputCapsule.write(this.getCcdSweptSphereRadius(), "ccdSweptSphereRadius", 0.0f);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.buildObject();
        this.setPhysicsLocation((Vector3f)inputCapsule.readSavable("physicsLocation", (Savable)new Vector3f()));
        this.setPhysicsRotation((Matrix3f)inputCapsule.readSavable("physicsRotation", (Savable)new Matrix3f()));
        this.setCcdMotionThreshold(inputCapsule.readFloat("ccdMotionThreshold", 0.0f));
        this.setCcdSweptSphereRadius(inputCapsule.readFloat("ccdSweptSphereRadius", 0.0f));
    }
}

