/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeightfieldCollisionShape
extends CollisionShape {
    protected int heightStickWidth;
    protected int heightStickLength;
    protected float[] heightfieldData;
    protected float heightScale;
    protected float minHeight;
    protected float maxHeight;
    protected int upAxis;
    protected boolean flipQuadEdges;
    protected ByteBuffer bbuf;

    public HeightfieldCollisionShape() {
    }

    public HeightfieldCollisionShape(float[] fArray) {
        this.createCollisionHeightfield(fArray, Vector3f.UNIT_XYZ);
    }

    public HeightfieldCollisionShape(float[] fArray, Vector3f vector3f) {
        this.createCollisionHeightfield(fArray, vector3f);
    }

    protected void createCollisionHeightfield(float[] fArray, Vector3f vector3f) {
        this.scale = vector3f;
        this.heightScale = 1.0f;
        this.heightfieldData = fArray;
        float f = this.heightfieldData[0];
        float f2 = this.heightfieldData[0];
        for (int i = 0; i < this.heightfieldData.length; ++i) {
            if (this.heightfieldData[i] < f) {
                f = this.heightfieldData[i];
            }
            if (!(this.heightfieldData[i] > f2)) continue;
            f2 = this.heightfieldData[i];
        }
        if (f2 < 0.0f) {
            f2 = -f;
        } else if (Math.abs(f2) > Math.abs(f)) {
            f = -f2;
        } else {
            f2 = -f;
        }
        this.minHeight = f;
        this.maxHeight = f2;
        this.upAxis = 1;
        this.flipQuadEdges = false;
        this.heightStickLength = this.heightStickWidth = (int)FastMath.sqrt((float)this.heightfieldData.length);
        this.createShape();
    }

    protected void createShape() {
        this.bbuf = BufferUtils.createByteBuffer((int)(this.heightfieldData.length * 4));
        for (int i = 0; i < this.heightfieldData.length; ++i) {
            float f = this.heightfieldData[i];
            this.bbuf.putFloat(f);
        }
        this.objectId = this.createShape(this.heightStickWidth, this.heightStickLength, this.bbuf, this.heightScale, this.minHeight, this.maxHeight, this.upAxis, this.flipQuadEdges);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(int var1, int var2, ByteBuffer var3, float var4, float var5, float var6, int var7, boolean var8);

    public Mesh createJmeMesh() {
        return null;
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.heightStickWidth, "heightStickWidth", 0);
        outputCapsule.write(this.heightStickLength, "heightStickLength", 0);
        outputCapsule.write(this.heightScale, "heightScale", 0.0f);
        outputCapsule.write(this.minHeight, "minHeight", 0.0f);
        outputCapsule.write(this.maxHeight, "maxHeight", 0.0f);
        outputCapsule.write(this.upAxis, "upAxis", 1);
        outputCapsule.write(this.heightfieldData, "heightfieldData", new float[0]);
        outputCapsule.write(this.flipQuadEdges, "flipQuadEdges", false);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.heightStickWidth = inputCapsule.readInt("heightStickWidth", 0);
        this.heightStickLength = inputCapsule.readInt("heightStickLength", 0);
        this.heightScale = inputCapsule.readFloat("heightScale", 0.0f);
        this.minHeight = inputCapsule.readFloat("minHeight", 0.0f);
        this.maxHeight = inputCapsule.readFloat("maxHeight", 0.0f);
        this.upAxis = inputCapsule.readInt("upAxis", 1);
        this.heightfieldData = inputCapsule.readFloatArray("heightfieldData", new float[0]);
        this.flipQuadEdges = inputCapsule.readBoolean("flipQuadEdges", false);
        this.createShape();
    }
}

