/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Capability;
import org.OpenNI.GeneralException;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.ObjectWrapper;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StatusException;
import org.OpenNI.Version;
import org.OpenNI.WrapperUtils;

public class Query
extends ObjectWrapper {
    public Query() throws GeneralException {
        super(Query.allocate());
    }

    public void setVendor(String vendor) throws StatusException {
        int status = NativeMethods.xnNodeQuerySetVendor(this.toNative(), vendor);
        WrapperUtils.throwOnError(status);
    }

    public void setName(String name) throws StatusException {
        int status = NativeMethods.xnNodeQuerySetName(this.toNative(), name);
        WrapperUtils.throwOnError(status);
    }

    public void setMinVersion(Version version) throws StatusException {
        int status = NativeMethods.xnNodeQuerySetMinVersion(this.toNative(), version.getMajor(), version.getMinor(), version.getMaintenance(), version.getBuild());
        WrapperUtils.throwOnError(status);
    }

    public void setMaxVersion(Version version) throws StatusException {
        int status = NativeMethods.xnNodeQuerySetMaxVersion(this.toNative(), version.getMajor(), version.getMinor(), version.getMaintenance(), version.getBuild());
        WrapperUtils.throwOnError(status);
    }

    public void addSupportedCapability(Capability capability) throws StatusException {
        int status = NativeMethods.xnNodeQueryAddSupportedCapability(this.toNative(), capability.getName());
        WrapperUtils.throwOnError(status);
    }

    public void addSupportedMapOutputMode(MapOutputMode mode) throws StatusException {
        int status = NativeMethods.xnNodeQueryAddSupportedMapOutputMode(this.toNative(), mode.getXRes(), mode.getYRes(), mode.getFPS());
        WrapperUtils.throwOnError(status);
    }

    public void addSupportedMinUserPositions(int count) throws StatusException {
        int status = NativeMethods.xnNodeQuerySetSupportedMinUserPositions(this.toNative(), count);
        WrapperUtils.throwOnError(status);
    }

    public void setExistingNodeOnly(boolean existingOnly) throws StatusException {
        int status = NativeMethods.xnNodeQuerySetExistingNodeOnly(this.toNative(), existingOnly);
        WrapperUtils.throwOnError(status);
    }

    public void setNonExistingNodeOnly(boolean nonExistingOnly) throws StatusException {
        int status = NativeMethods.xnNodeQuerySetNonExistingNodeOnly(this.toNative(), nonExistingOnly);
        WrapperUtils.throwOnError(status);
    }

    public void addNeededNode(ProductionNode node) throws StatusException {
        int status = NativeMethods.xnNodeQueryAddNeededNode(this.toNative(), node.getName());
        WrapperUtils.throwOnError(status);
    }

    public void setCreationInfo(String creationInfo) throws StatusException {
        int status = NativeMethods.xnNodeQuerySetCreationInfo(this.toNative(), creationInfo);
        WrapperUtils.throwOnError(status);
    }

    @Override
    protected void freeObject(long ptr) {
        NativeMethods.xnNodeQueryFree(ptr);
    }

    private static long allocate() throws StatusException {
        OutArg<Long> pQuery = new OutArg<Long>();
        int status = NativeMethods.xnNodeQueryAllocate(pQuery);
        WrapperUtils.throwOnError(status);
        return (Long)pQuery.value;
    }
}

