/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.IObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.PoseDetectionEventArgs;
import org.OpenNI.PoseDetectionInProgressEventArgs;
import org.OpenNI.PoseDetectionStatus;
import org.OpenNI.ProductionNode;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class PoseDetectionCapability
extends CapabilityBase {
    private Observable<PoseDetectionEventArgs> poseDetectedEvent = new Observable<PoseDetectionEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToPoseDetected(PoseDetectionCapability.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromPoseDetected(PoseDetectionCapability.this.toNative(), hCallback);
        }

        public void callback(String pose, int user) {
            this.notify(new PoseDetectionEventArgs(pose, user));
        }
    };
    private Observable<PoseDetectionEventArgs> outOfPoseEvent = new Observable<PoseDetectionEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToOutOfPose(PoseDetectionCapability.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromOutOfPose(PoseDetectionCapability.this.toNative(), hCallback);
        }

        public void callback(String pose, int user) {
            this.notify(new PoseDetectionEventArgs(pose, user));
        }
    };
    private Observable<PoseDetectionInProgressEventArgs> poseDetectionInProgressEvent = new Observable<PoseDetectionInProgressEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToPoseDetectionInProgress(PoseDetectionCapability.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromPoseDetectionInProgress(PoseDetectionCapability.this.toNative(), hCallback);
        }

        public void callback(String pose, int user, int status) {
            this.notify(new PoseDetectionInProgressEventArgs(pose, user, PoseDetectionStatus.fromNative(status)));
        }
    };

    public PoseDetectionCapability(ProductionNode node) throws StatusException {
        super(node);
    }

    public int getNumberOfPoses() {
        return NativeMethods.xnGetNumberOfPoses(this.toNative());
    }

    public String[] getAllAvailablePoses() throws StatusException {
        OutArg<String[]> poses = new OutArg<String[]>();
        int status = NativeMethods.xnGetAllAvailablePoses(this.toNative(), poses);
        WrapperUtils.throwOnError(status);
        return (String[])poses.value;
    }

    public void StartPoseDetection(String pose, int user) throws StatusException {
        int status = NativeMethods.xnStartPoseDetection(this.toNative(), pose, user);
        WrapperUtils.throwOnError(status);
    }

    public void StopPoseDetection(int user) throws StatusException {
        int status = NativeMethods.xnStopPoseDetection(this.toNative(), user);
        WrapperUtils.throwOnError(status);
    }

    public IObservable<PoseDetectionEventArgs> getPoseDetectedEvent() {
        return this.poseDetectedEvent;
    }

    public IObservable<PoseDetectionEventArgs> getOutOfPoseEvent() {
        return this.outOfPoseEvent;
    }

    public IObservable<PoseDetectionInProgressEventArgs> getPoseDetectionInProgressEvent() {
        return this.poseDetectionInProgressEvent;
    }
}

