/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import java.util.Hashtable;
import org.OpenNI.AudioGenerator;
import org.OpenNI.Codec;
import org.OpenNI.DepthGenerator;
import org.OpenNI.Device;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.ErrorStateEventArgs;
import org.OpenNI.GeneralException;
import org.OpenNI.Generator;
import org.OpenNI.GestureGenerator;
import org.OpenNI.HandsGenerator;
import org.OpenNI.IObservable;
import org.OpenNI.IRGenerator;
import org.OpenNI.ImageGenerator;
import org.OpenNI.License;
import org.OpenNI.MapGenerator;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeInfo;
import org.OpenNI.NodeInfoList;
import org.OpenNI.NodeType;
import org.OpenNI.ObjectWrapper;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Player;
import org.OpenNI.ProductionNode;
import org.OpenNI.Query;
import org.OpenNI.Recorder;
import org.OpenNI.SceneAnalyzer;
import org.OpenNI.ScriptNode;
import org.OpenNI.StatusException;
import org.OpenNI.UserGenerator;
import org.OpenNI.Version;
import org.OpenNI.WrapperUtils;

public class Context
extends ObjectWrapper {
    private Observable<ErrorStateEventArgs> errorStateChangedEvent;
    private Hashtable<Long, ProductionNode> allNodes = new Hashtable();
    private static Hashtable<Long, Context> allContexts = new Hashtable();

    public Context() throws GeneralException {
        this(Context.init(), false);
    }

    public static Context createFromXmlFile(String xmlFile, OutArg<ScriptNode> scriptNode) throws GeneralException {
        OutArg<Long> hScript = new OutArg<Long>();
        long pContext = Context.initFromXmlEx(xmlFile, hScript);
        Context context = new Context(pContext, false);
        scriptNode.value = new ScriptNode(context, (Long)hScript.value, false);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context fromNative(long pContext) throws GeneralException {
        Hashtable<Long, Context> hashtable = allContexts;
        synchronized (hashtable) {
            if (allContexts.containsKey(pContext)) {
                return allContexts.get(pContext);
            }
            return new Context(pContext);
        }
    }

    public static Version getVersion() throws StatusException {
        OutArg<Version> pVersion = new OutArg<Version>();
        int status = NativeMethods.xnGetVersion(pVersion);
        WrapperUtils.throwOnError(status);
        return (Version)pVersion.value;
    }

    public ScriptNode runXmlScriptFromFile(String scriptFile) throws GeneralException {
        EnumerationErrors errors = new EnumerationErrors();
        OutArg<Long> phScriptNode = new OutArg<Long>();
        int status = NativeMethods.xnContextRunXmlScriptFromFileEx(this.toNative(), scriptFile, errors.toNative(), phScriptNode);
        WrapperUtils.checkEnumeration(status, errors);
        return new ScriptNode(this, (Long)phScriptNode.value, false);
    }

    public ScriptNode runXmlScript(String script) throws GeneralException {
        EnumerationErrors errors = new EnumerationErrors();
        OutArg<Long> phScriptNode = new OutArg<Long>();
        int status = NativeMethods.xnContextRunXmlScriptEx(this.toNative(), script, errors.toNative(), phScriptNode);
        WrapperUtils.checkEnumeration(status, errors);
        return new ScriptNode(this, (Long)phScriptNode.value, false);
    }

    public Player openFileRecordingEx(String fileName) throws GeneralException {
        OutArg<Long> phPlayer = new OutArg<Long>();
        int status = NativeMethods.xnContextOpenFileRecordingEx(this.toNative(), fileName, phPlayer);
        WrapperUtils.throwOnError(status);
        return (Player)Context.createProductionNodeFromNative((Long)phPlayer.value);
    }

    public void release() {
        this.dispose();
    }

    public void addLicense(License license) throws StatusException {
        int status = NativeMethods.xnAddLicense(this.toNative(), license.getVendor(), license.getKey());
        WrapperUtils.throwOnError(status);
    }

    public License[] enumerateLicenses() throws StatusException {
        OutArg<License[]> licenses = new OutArg<License[]>();
        int status = NativeMethods.xnEnumerateLicenses(this.toNative(), licenses);
        WrapperUtils.throwOnError(status);
        return (License[])licenses.value;
    }

    public NodeInfoList enumerateProductionTrees(NodeType type, Query query) throws GeneralException {
        EnumerationErrors errors = new EnumerationErrors();
        OutArg<Long> ppNodesList = new OutArg<Long>();
        int status = NativeMethods.xnEnumerateProductionTrees(this.toNative(), type.toNative(), query == null ? 0L : query.toNative(), ppNodesList, errors.toNative());
        WrapperUtils.checkEnumeration(status, errors);
        return new NodeInfoList((Long)ppNodesList.value);
    }

    public NodeInfoList enumerateProductionTrees(NodeType type) throws GeneralException {
        return this.enumerateProductionTrees(type, null);
    }

    public ProductionNode createProductionTree(NodeInfo nodeInfo) throws GeneralException {
        OutArg<Long> phNode = new OutArg<Long>();
        int status = NativeMethods.xnCreateProductionTree(this.toNative(), nodeInfo.toNative(), phNode);
        WrapperUtils.throwOnError(status);
        return this.createProductionNodeObject((Long)phNode.value);
    }

    public ProductionNode createAnyProductionTree(NodeType type, Query query) throws GeneralException {
        EnumerationErrors errors = new EnumerationErrors();
        OutArg<Long> phNode = new OutArg<Long>();
        int status = NativeMethods.xnCreateAnyProductionTree(this.toNative(), type.toNative(), query == null ? 0L : query.toNative(), phNode, errors.toNative());
        WrapperUtils.checkEnumeration(status, errors);
        return Context.createProductionNodeFromNative((Long)phNode.value);
    }

    public NodeInfoList enumerateExistingNodes() throws GeneralException {
        OutArg<Long> ppList = new OutArg<Long>();
        int status = NativeMethods.xnEnumerateExistingNodes(this.toNative(), ppList);
        WrapperUtils.throwOnError(status);
        return new NodeInfoList((Long)ppList.value);
    }

    public NodeInfoList enumerateExistingNodes(NodeType type) throws GeneralException {
        OutArg<Long> ppList = new OutArg<Long>();
        int status = NativeMethods.xnEnumerateExistingNodesByType(this.toNative(), type.toNative(), ppList);
        WrapperUtils.throwOnError(status);
        return new NodeInfoList((Long)ppList.value);
    }

    public ProductionNode findExistingNode(NodeType type) throws GeneralException {
        OutArg<Long> phNode = new OutArg<Long>();
        int status = NativeMethods.xnFindExistingRefNodeByType(this.toNative(), type.toNative(), phNode);
        WrapperUtils.throwOnError(status);
        ProductionNode node = this.createProductionNodeObject((Long)phNode.value, type);
        NativeMethods.xnProductionNodeRelease((Long)phNode.value);
        return node;
    }

    public ProductionNode getProductionNodeByName(String name) throws GeneralException {
        OutArg<Long> phNode = new OutArg<Long>();
        int status = NativeMethods.xnGetRefNodeHandleByName(this.toNative(), name, phNode);
        WrapperUtils.throwOnError(status);
        ProductionNode node = this.createProductionNodeObject((Long)phNode.value);
        NativeMethods.xnProductionNodeRelease((Long)phNode.value);
        return node;
    }

    public NodeInfo getProductionNodeInfoByName(String name) throws GeneralException {
        return this.getProductionNodeByName(name).getInfo();
    }

    public void startGeneratingAll() throws StatusException {
        int status = NativeMethods.xnStartGeneratingAll(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void stopGeneratingAll() throws StatusException {
        int status = NativeMethods.xnStopGeneratingAll(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public boolean getGlobalMirror() {
        return NativeMethods.xnGetGlobalMirror(this.toNative());
    }

    public void setGlobalMirror(boolean mirror) throws StatusException {
        int status = NativeMethods.xnSetGlobalMirror(this.toNative(), mirror);
        WrapperUtils.throwOnError(status);
    }

    public void waitAndUpdateAll() throws StatusException {
        int status = NativeMethods.xnWaitAndUpdateAll(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void waitOneUpdateAll(ProductionNode waitFor) throws StatusException {
        int status = NativeMethods.xnWaitOneUpdateAll(this.toNative(), waitFor.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void waitAnyUpdateAll() throws StatusException {
        int status = NativeMethods.xnWaitAnyUpdateAll(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void waitNoneUpdateAll() throws StatusException {
        int status = NativeMethods.xnWaitNoneUpdateAll(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public IObservable<ErrorStateEventArgs> getErrorStateChangedEvent() {
        return this.errorStateChangedEvent;
    }

    public static ProductionNode createProductionNodeFromNative(long nodeHandle) throws GeneralException {
        long pContext = NativeMethods.xnGetRefContextFromNodeHandle(nodeHandle);
        Context context = Context.fromNative(pContext);
        NativeMethods.xnContextRelease(pContext);
        return context.createProductionNodeObject(nodeHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void freeObject(long ptr) {
        Hashtable<Long, Context> hashtable = allContexts;
        synchronized (hashtable) {
            allContexts.remove(ptr);
        }
        NativeMethods.xnContextRelease(ptr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context(long pContext, boolean addRef) throws GeneralException {
        super(pContext);
        this.errorStateChangedEvent = new Observable<ErrorStateEventArgs>(){

            @Override
            protected int registerNative(OutArg<Long> phCallback) throws StatusException {
                return NativeMethods.xnRegisterToGlobalErrorStateChange(Context.this.toNative(), this, "callback", phCallback);
            }

            @Override
            protected void unregisterNative(long hCallback) {
                NativeMethods.xnUnregisterFromGlobalErrorStateChange(Context.this.toNative(), hCallback);
            }

            public void callback(int status) {
                this.notify(new ErrorStateEventArgs(status));
            }
        };
        Hashtable<Long, Context> hashtable = allContexts;
        synchronized (hashtable) {
            if (allContexts.containsKey(pContext)) {
                throw new GeneralException("Java wrapper: creating a Context object wrapping an already wrapped object!");
            }
            allContexts.put(pContext, this);
        }
        if (addRef) {
            WrapperUtils.throwOnError(NativeMethods.xnContextAddRef(pContext));
        }
    }

    private Context(long pContext) throws GeneralException {
        this(pContext, true);
    }

    private static long init() throws StatusException {
        OutArg<Long> pContext = new OutArg<Long>();
        int status = NativeMethods.xnInit(pContext);
        WrapperUtils.throwOnError(status);
        return (Long)pContext.value;
    }

    private static long initFromXmlEx(String xmlFile, OutArg<Long> hScriptNode) throws StatusException {
        OutArg<Long> pContext = new OutArg<Long>();
        int status = NativeMethods.xnInitFromXmlFileEx(xmlFile, pContext, 0L, hScriptNode);
        WrapperUtils.throwOnError(status);
        return (Long)pContext.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProductionNode createProductionNodeObject(long nodeHandle, NodeType type) throws GeneralException {
        Hashtable<Long, ProductionNode> hashtable = this.allNodes;
        synchronized (hashtable) {
            if (!this.allNodes.containsKey(nodeHandle)) {
                ProductionNode node;
                if (type.equals(NodeType.DEVICE)) {
                    node = new Device(this, nodeHandle, true);
                } else if (type.equals(NodeType.DEPTH)) {
                    node = new DepthGenerator(this, nodeHandle, true);
                } else if (type.equals(NodeType.IMAGE)) {
                    node = new ImageGenerator(this, nodeHandle, true);
                } else if (type.equals(NodeType.AUDIO)) {
                    node = new AudioGenerator(this, nodeHandle, true);
                } else if (type.equals(NodeType.IR)) {
                    node = new IRGenerator(this, nodeHandle, true);
                } else if (type.equals(NodeType.USER)) {
                    node = new UserGenerator(this, nodeHandle, true);
                } else if (type.equals(NodeType.RECORDER)) {
                    node = new Recorder(this, nodeHandle, true);
                } else if (type.equals(NodeType.PLAYER)) {
                    node = new Player(this, nodeHandle, true);
                } else if (type.equals(NodeType.GESTURE)) {
                    node = new GestureGenerator(this, nodeHandle, true);
                } else if (type.equals(NodeType.SCENE)) {
                    node = new SceneAnalyzer(this, nodeHandle, true);
                } else if (type.equals(NodeType.HANDS)) {
                    node = new HandsGenerator(this, nodeHandle, true);
                } else if (type.equals(NodeType.CODEC)) {
                    node = new Codec(this, nodeHandle, true);
                } else if (type.equals(NodeType.SCRIPT_NODE)) {
                    node = new ScriptNode(this, nodeHandle, true);
                } else if (type.equals(NodeType.PRODUCTION_NODE)) {
                    node = new ProductionNode(this, nodeHandle, true);
                } else if (type.equals(NodeType.GENERATOR)) {
                    node = new Generator(this, nodeHandle, true);
                } else if (type.equals(NodeType.MAP_GENERATOR)) {
                    node = new MapGenerator(this, nodeHandle, true);
                } else {
                    throw new GeneralException("java wrapper: Unknown generator type!");
                }
                this.allNodes.put(nodeHandle, node);
            }
            return this.allNodes.get(nodeHandle);
        }
    }

    ProductionNode createProductionNodeObject(long hNode) throws GeneralException {
        long pNodeInfo = NativeMethods.xnGetNodeInfo(hNode);
        NodeType type = NativeMethods.xnNodeInfoGetDescription(pNodeInfo).getType();
        return this.createProductionNodeObject(hNode, type);
    }
}

