/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.AudioMetaData;
import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.Generator;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WaveOutputMode;
import org.OpenNI.WrapperUtils;

public class AudioGenerator
extends Generator {
    private StateChangedObservable waveOutputModeChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToWaveOutputModeChanges(AudioGenerator.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromWaveOutputModeChanges(AudioGenerator.this.toNative(), hCallback);
        }
    };

    public AudioGenerator(Context context, long nodeHandle, boolean addRef) throws GeneralException {
        super(context, nodeHandle, addRef);
    }

    public static AudioGenerator create(Context context, Query query, EnumerationErrors errors) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateAudioGenerator(context.toNative(), handle, query == null ? 0L : query.toNative(), errors == null ? 0L : errors.toNative());
        WrapperUtils.throwOnError(status);
        AudioGenerator result = (AudioGenerator)context.createProductionNodeObject((Long)handle.value, NodeType.AUDIO);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public static AudioGenerator create(Context context, Query query) throws GeneralException {
        return AudioGenerator.create(context, query, null);
    }

    public static AudioGenerator create(Context context) throws GeneralException {
        return AudioGenerator.create(context, null, null);
    }

    public WaveOutputMode[] getSupportedMapOutputModes() throws StatusException {
        int count = NativeMethods.xnGetSupportedWaveOutputModesCount(this.toNative());
        WaveOutputMode[] supportedModes = new WaveOutputMode[count];
        int status = NativeMethods.xnGetSupportedWaveOutputModes(this.toNative(), supportedModes);
        WrapperUtils.throwOnError(status);
        return supportedModes;
    }

    public WaveOutputMode getWaveOutputMode() throws StatusException {
        OutArg<Integer> sampleRate = new OutArg<Integer>();
        OutArg<Short> bitsPerSample = new OutArg<Short>();
        OutArg<Byte> numberOfChannels = new OutArg<Byte>();
        int status = NativeMethods.xnGetWaveOutputMode(this.toNative(), sampleRate, bitsPerSample, numberOfChannels);
        WrapperUtils.throwOnError(status);
        return new WaveOutputMode((Integer)sampleRate.value, (Short)bitsPerSample.value, (Byte)numberOfChannels.value);
    }

    public void setWaveOutputMode(WaveOutputMode mode) throws StatusException {
        int status = NativeMethods.xnSetWaveOutputMode(this.toNative(), mode.getSampleRate(), mode.getBitsPerSample(), mode.getNumberOfChannels());
        WrapperUtils.throwOnError(status);
    }

    public IStateChangedObservable getMapOutputModeChangedEvent() {
        return this.waveOutputModeChanged;
    }

    public void getMetaData(AudioMetaData audioMD) {
        NativeMethods.xnGetAudioMetaData(this.toNative(), audioMD);
    }

    public AudioMetaData getMetaData() {
        AudioMetaData audioMD = new AudioMetaData();
        this.getMetaData(audioMD);
        return audioMD;
    }
}

