package projectkyoto.android.sample.gomyway2;

import com.jme3.app.SimpleApplication;
import com.jme3.font.BitmapText;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.PointLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.texture.plugins.AndroidImageLoader;
import java.text.DecimalFormat;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.lwjgl.opengl.GL11;
import projectkyoto.jme3.mmd.CartoonEdgeProcessor;
import projectkyoto.jme3.mmd.PMDLoaderGLSLSkinning2;
import projectkyoto.jme3.mmd.PMDNode;
import projectkyoto.jme3.mmd.UpdateControl;
import projectkyoto.jme3.mmd.VMDLoader;
import projectkyoto.jme3.mmd.vmd.VMDControl;
import projectkyoto.jme3.mmd.vmd.VMDControlMT;
import projectkyoto.mmd.file.VMDFile;

/**
 * test
 * <p/>
 * @author kobayasi
 */
public class MainMT extends SimpleApplication {

    PointLight pl;
    Geometry lightMdl;
    VMDControlMT vmdControlMT;
    VMDControl vmdControl;
    ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(4);
    long startNanoTime = 0;
    long endNanoTime = 0;
    int frameCount = 0;
    BitmapText resultText;
    public static void main(String[] args) {
//        com.jme3.system.JmeSystem.setLowPermissions(true);
        MainMT app = new MainMT();
        app.start();
    }

    @Override
    public void simpleInitApp() {
        flyCam.setMoveSpeed(50);
        flyCam.setEnabled(false);
        // Load Model
        assetManager.registerLoader(PMDLoaderGLSLSkinning2.class, "pmd");
        assetManager.registerLoader(VMDLoader.class, "vmd");
        assetManager.registerLoader(AndroidImageLoader.class,"sph","spa");
        PMDNode pmdNode = (PMDNode) assetManager.loadModel("/Model/miku.pmd");
        VMDFile vmd = (VMDFile) assetManager.loadAsset("/motion/gomyway.vmd");
//        vmdControl = new VMDControl(pmdNode, vmd);
        vmdControlMT = new VMDControlMT(pool, pmdNode, vmd);
        vmdControl = vmdControlMT.getCallable().getVmdControl();
//        pmdNode.addControl(vmdControlMT);
//        pmdNode.addControl(new UpdateControl(pmdNode));
//        pmdNode.setGlslSkinning(false);
        pmdNode.setGlslSkinning(true);
        pmdNode.getSkeleton().updateWorldVectors();
        pmdNode.update();
        vmdControl.setFrameNo(0);
        vmdControl.setPause(true);

        rootNode.attachChild(pmdNode);

        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1, 0, -5).normalizeLocal());
        dl.setColor(ColorRGBA.White.mult(0.5f));
        rootNode.addLight(dl);
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(1.0f));
        rootNode.addLight(al);
        CartoonEdgeProcessor cartoonEdgeProcess = new CartoonEdgeProcessor();
        viewPort.addProcessor(cartoonEdgeProcess);

        cam.setLocation(new Vector3f(0, 10, 40));
        loadResultText();
        setDisplayFps(false);
        setDisplayStatView(false);
        setPauseOnLostFocus(false);
        
        vmdControl.setAccuracy(stepTime);
    }
    float time = 0;
    float stepTime = 1f / 60f;

    @Override
    public void simpleUpdate(float tpf) {
        time += tpf;
        if (time > 5) {
            // start after 5 seconds.
            if (vmdControl != null && vmdControl.isPause()) {
                vmdControl.setPause(false);
                startNanoTime = System.nanoTime();
                frameCount = 0;
            }
        }
        if (vmdControl.getFrameNo() > vmdControl.getLastFrameNo() && !vmdControl.isPause()) {
            endNanoTime = System.nanoTime();
            vmdControl.setPause(true);
            vmdControl.setFrameNo(0);
            if (frameCount > 0) {
                float fps = (float)frameCount / (endNanoTime - startNanoTime) * 1000000000;
                DecimalFormat df = new DecimalFormat("0.000");
                resultText.setText("result : " + df.format(fps)+" fps");
            }
            time = 5;
        }
        if (!vmdControl.isPause()) {
            vmdControlMT.update(stepTime);
            frameCount++;
        }
    }
    public void loadResultText() {
        resultText = new BitmapText(guiFont, false);
        resultText.setSize(guiFont.getCharSet().getRenderedSize());
        resultText.setLocalTranslation(0, getCamera().getHeight() - 50, 50);
        resultText.setText("result : 0");
        guiNode.attachChild(resultText);
    }    

    @Override
    public void destroy() {
        super.destroy();
        pool.shutdown();
    }
    
}
