/*
 * Decompiled with CFR 0.152.
 */
package cz.advel.stack.instrument;

import cz.advel.stack.instrument.Instrumenter;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class StackGenerator
implements Opcodes {
    StackGenerator() {
    }

    private static int getParentDistance(Class concrete, Class parent) {
        int cnt = 0;
        while (concrete != null && concrete != parent) {
            ++cnt;
            concrete = concrete.getSuperclass();
        }
        return cnt;
    }

    public static Method findGetMethodType(String type) {
        try {
            Class<?> cls = Class.forName(type.replace('/', '.'));
            Method bestMethod = null;
            int bestDist = Integer.MAX_VALUE;
            for (Method method : cls.getMethods()) {
                if (!method.getName().equals("set") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(cls)) continue;
                int dist = StackGenerator.getParentDistance(cls, method.getParameterTypes()[0]);
                if (bestMethod != null && dist >= bestDist) continue;
                bestMethod = method;
                bestDist = dist;
            }
            if (bestMethod == null) {
                throw new IllegalStateException("can't find set method for " + cls);
            }
            return bestMethod;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] generateStackClass(Instrumenter instr, String[] types) {
        String mangled;
        FieldVisitor fv;
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 49, instr.getStackInternalName(), null, "java/lang/Object", null);
        cw.visitInnerClass(instr.getStackInternalName() + "$1", null, null, 24);
        if (instr.isSingleThread()) {
            fv = cw.visitField(25, "INSTANCE", "L" + instr.getStackInternalName() + ";", null, null);
            fv.visitEnd();
        } else {
            fv = cw.visitField(25, "threadLocal", "Ljava/lang/ThreadLocal;", null, null);
            fv.visitEnd();
        }
        for (String type : types) {
            mangled = Instrumenter.mangleInternalName(type);
            fv = cw.visitField(2, "list$" + mangled, "Ljava/util/ArrayList;", null, null);
            fv.visitEnd();
            fv = cw.visitField(2, "stack$" + mangled, "[I", null, null);
            fv.visitEnd();
            fv = cw.visitField(2, "count$" + mangled, "I", null, null);
            fv.visitEnd();
            fv = cw.visitField(2, "pos$" + mangled, "I", null, null);
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        for (String type : types) {
            mangled = Instrumenter.mangleInternalName(type);
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, "java/util/ArrayList");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
            mv.visitFieldInsn(181, instr.getStackInternalName(), "list$" + mangled, "Ljava/util/ArrayList;");
            mv.visitVarInsn(25, 0);
            mv.visitIntInsn(16, 16);
            mv.visitIntInsn(188, 10);
            mv.visitFieldInsn(181, instr.getStackInternalName(), "stack$" + mangled, "[I");
            mv.visitVarInsn(25, 0);
            mv.visitInsn(3);
            mv.visitFieldInsn(181, instr.getStackInternalName(), "count$" + mangled, "I");
            mv.visitVarInsn(25, 0);
            mv.visitInsn(3);
            mv.visitFieldInsn(181, instr.getStackInternalName(), "pos$" + mangled, "I");
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        if (!instr.isSingleThread()) {
            mv = cw.visitMethod(9, "get", "()L" + instr.getStackInternalName() + ";", null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, instr.getStackInternalName(), "threadLocal", "Ljava/lang/ThreadLocal;");
            mv.visitMethodInsn(182, "java/lang/ThreadLocal", "get", "()Ljava/lang/Object;");
            mv.visitTypeInsn(192, instr.getStackInternalName());
            mv.visitInsn(176);
            mv.visitMaxs(1, 0);
            mv.visitEnd();
        }
        for (String type : types) {
            mangled = Instrumenter.mangleInternalName(type);
            mv = cw.visitMethod(1, "push$" + mangled, "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "count$" + mangled, "I");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "stack$" + mangled, "[I");
            mv.visitInsn(190);
            Label l0 = new Label();
            mv.visitJumpInsn(160, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, instr.getStackInternalName(), "resize$" + mangled, "()V");
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "stack$" + mangled, "[I");
            mv.visitVarInsn(25, 0);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "count$" + mangled, "I");
            mv.visitInsn(90);
            mv.visitInsn(4);
            mv.visitInsn(96);
            mv.visitFieldInsn(181, instr.getStackInternalName(), "count$" + mangled, "I");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "pos$" + mangled, "I");
            mv.visitInsn(79);
            mv.visitInsn(177);
            mv.visitMaxs(5, 1);
            mv.visitEnd();
            mv = cw.visitMethod(2, "resize$" + mangled, "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "stack$" + mangled, "[I");
            mv.visitInsn(190);
            mv.visitInsn(4);
            mv.visitInsn(120);
            mv.visitIntInsn(188, 10);
            mv.visitVarInsn(58, 1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "stack$" + mangled, "[I");
            mv.visitInsn(3);
            mv.visitVarInsn(25, 1);
            mv.visitInsn(3);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "stack$" + mangled, "[I");
            mv.visitInsn(190);
            mv.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, instr.getStackInternalName(), "stack$" + mangled, "[I");
            mv.visitInsn(177);
            mv.visitMaxs(5, 2);
            mv.visitEnd();
            mv = cw.visitMethod(1, "pop$" + mangled, "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "stack$" + mangled, "[I");
            mv.visitVarInsn(25, 0);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "count$" + mangled, "I");
            mv.visitInsn(4);
            mv.visitInsn(100);
            mv.visitInsn(90);
            mv.visitFieldInsn(181, instr.getStackInternalName(), "count$" + mangled, "I");
            mv.visitInsn(46);
            mv.visitFieldInsn(181, instr.getStackInternalName(), "pos$" + mangled, "I");
            mv.visitInsn(177);
            mv.visitMaxs(5, 1);
            mv.visitEnd();
            mv = cw.visitMethod(1, "get$" + mangled, "()L" + type + ";", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "pos$" + mangled, "I");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "list$" + mangled, "Ljava/util/ArrayList;");
            mv.visitMethodInsn(182, "java/util/ArrayList", "size", "()I");
            l0 = new Label();
            mv.visitJumpInsn(160, l0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "list$" + mangled, "Ljava/util/ArrayList;");
            mv.visitTypeInsn(187, type);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, type, "<init>", "()V");
            mv.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "list$" + mangled, "Ljava/util/ArrayList;");
            mv.visitVarInsn(25, 0);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, instr.getStackInternalName(), "pos$" + mangled, "I");
            mv.visitInsn(90);
            mv.visitInsn(4);
            mv.visitInsn(96);
            mv.visitFieldInsn(181, instr.getStackInternalName(), "pos$" + mangled, "I");
            mv.visitMethodInsn(182, "java/util/ArrayList", "get", "(I)Ljava/lang/Object;");
            mv.visitTypeInsn(192, type);
            mv.visitInsn(176);
            mv.visitMaxs(5, 1);
            mv.visitEnd();
            mv = cw.visitMethod(1, "get$" + mangled, "(L" + type + ";)L" + type + ";", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, instr.getStackInternalName(), "get$" + mangled, "()L" + type + ";");
            mv.visitVarInsn(58, 2);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            Method m = StackGenerator.findGetMethodType(type);
            mv.visitMethodInsn(182, type, "set", "(L" + Type.getInternalName(m.getParameterTypes()[0]) + ";)V");
            mv.visitVarInsn(25, 2);
            mv.visitInsn(176);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
        }
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        if (instr.isSingleThread()) {
            mv.visitTypeInsn(187, instr.getStackInternalName());
            mv.visitInsn(89);
            mv.visitMethodInsn(183, instr.getStackInternalName(), "<init>", "()V");
            mv.visitFieldInsn(179, instr.getStackInternalName(), "INSTANCE", "L" + instr.getStackInternalName() + ";");
            mv.visitInsn(177);
            mv.visitMaxs(2, 0);
        } else {
            mv.visitTypeInsn(187, instr.getStackInternalName() + "$1");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, instr.getStackInternalName() + "$1", "<init>", "()V");
            mv.visitFieldInsn(179, instr.getStackInternalName(), "threadLocal", "Ljava/lang/ThreadLocal;");
            if (!instr.isIsolated()) {
                mv.visitFieldInsn(178, instr.getStackInternalName(), "threadLocal", "Ljava/lang/ThreadLocal;");
                mv.visitMethodInsn(184, Instrumenter.STACK_NAME, "internalRegisterThreadLocal", "(Ljava/lang/ThreadLocal;)V");
            }
            mv.visitInsn(177);
            mv.visitMaxs(2, 0);
        }
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static byte[] generateStackClass1(Instrumenter instr) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 48, instr.getStackInternalName() + "$1", null, "java/lang/ThreadLocal", null);
        cw.visitOuterClass(instr.getStackInternalName(), null, null);
        cw.visitInnerClass(instr.getStackInternalName() + "$1", null, null, 24);
        MethodVisitor mv = cw.visitMethod(0, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/ThreadLocal", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "initialValue", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, instr.getStackInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, instr.getStackInternalName(), "<init>", "()V");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

