/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.objects;

import com.jme3.light.DirectionalLight;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.animations.ArmatureHelper;
import com.jme3.scene.plugins.blender.cameras.CameraHelper;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.curves.CurvesHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.lights.LightHelper;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.modifiers.ModifierHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ObjectHelper.class.getName());
    protected static final int OBJECT_TYPE_EMPTY = 0;
    protected static final int OBJECT_TYPE_MESH = 1;
    protected static final int OBJECT_TYPE_CURVE = 2;
    protected static final int OBJECT_TYPE_SURF = 3;
    protected static final int OBJECT_TYPE_TEXT = 4;
    protected static final int OBJECT_TYPE_METABALL = 5;
    protected static final int OBJECT_TYPE_LAMP = 10;
    protected static final int OBJECT_TYPE_CAMERA = 11;
    protected static final int OBJECT_TYPE_WAVE = 21;
    protected static final int OBJECT_TYPE_LATTICE = 22;
    protected static final int OBJECT_TYPE_ARMATURE = 25;
    protected static final Collection<Integer> invisibleTypes = new ArrayList<Integer>();
    protected boolean fixUpAxis;
    protected Quaternion upAxisRotationQuaternion;

    public ObjectHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public void setyIsUpAxis(boolean fixUpAxis) {
        this.fixUpAxis = fixUpAxis;
        if (fixUpAxis) {
            this.upAxisRotationQuaternion = new Quaternion().fromAngles(-1.5707964f, 0.0f, 0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object toObject(Structure objectStructure, DataRepository dataRepository) throws BlenderFileException {
        loadedResult = dataRepository.getLoadedFeature(objectStructure.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (loadedResult != null) {
            return loadedResult;
        }
        dataRepository.pushParent(objectStructure);
        objectHelper = (ObjectHelper)dataRepository.getHelper(ObjectHelper.class);
        armatureHelper = (ArmatureHelper)dataRepository.getHelper(ArmatureHelper.class);
        type = ((Number)objectStructure.getFieldValue("type")).intValue();
        name = objectStructure.getName();
        ObjectHelper.LOGGER.log(Level.INFO, "Loading obejct: {0}", name);
        constraintHelper = (ConstraintHelper)dataRepository.getHelper(ConstraintHelper.class);
        constraintHelper.loadConstraints(objectStructure, dataRepository);
        restrictflag = ((Number)objectStructure.getFieldValue("restrictflag")).intValue();
        visible = (restrictflag & 1) != 0;
        result = null;
        pParent = (Pointer)objectStructure.getFieldValue("parent");
        parent = dataRepository.getLoadedFeature(pParent.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (parent == null && pParent.isNotNull()) {
            parentStructure = pParent.fetchData(dataRepository.getInputStream()).get(0);
            parent = this.toObject(parentStructure, dataRepository);
        }
        t = objectHelper.getTransformation(objectStructure, dataRepository);
        try {
            switch (type) {
                case 0: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing empty.");
                    empty = new Node(name);
                    empty.setLocalTransform(t);
                    result = empty;
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 1: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing mesh.");
                    node = new Node(name);
                    node.setCullHint(visible != false ? Spatial.CullHint.Always : Spatial.CullHint.Inherit);
                    meshHelper = (MeshHelper)dataRepository.getHelper(MeshHelper.class);
                    pMesh = (Pointer)objectStructure.getFieldValue("data");
                    meshesArray = pMesh.fetchData(dataRepository.getInputStream());
                    geometries = meshHelper.toMesh(meshesArray.get(0), dataRepository);
                    if (geometries != null) {
                        for (Geometry geometry : geometries) {
                            node.attachChild(geometry);
                        }
                    }
                    node.setLocalTransform(t);
                    modifierHelper = (ModifierHelper)dataRepository.getHelper(ModifierHelper.class);
                    modifiers = modifierHelper.readModifiers(objectStructure, dataRepository);
                    for (Modifier modifier : modifiers) {
                        modifier.apply(node, dataRepository);
                    }
                    if (parent instanceof Node) {
                        ((Node)parent).attachChild(node);
                    }
                    node.updateModelBound();
                    result = node;
                    ** break;
lbl57:
                    // 1 sources

                    break;
                }
                case 2: 
                case 3: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing curve/nurb.");
                    pCurve = (Pointer)objectStructure.getFieldValue("data");
                    if (pCurve.isNotNull()) {
                        curvesHelper = (CurvesHelper)dataRepository.getHelper(CurvesHelper.class);
                        curveData = pCurve.fetchData(dataRepository.getInputStream()).get(0);
                        curves = curvesHelper.toCurve(curveData, dataRepository);
                        result = new Node(name);
                        for (Geometry curve : curves) {
                            result.attachChild(curve);
                        }
                        result.setLocalTransform(t);
                        ** break;
                    }
lbl72:
                    // 3 sources

                    break;
                }
                case 10: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing lamp.");
                    pLamp = (Pointer)objectStructure.getFieldValue("data");
                    if (pLamp.isNotNull()) {
                        lightHelper = (LightHelper)dataRepository.getHelper(LightHelper.class);
                        light = lightHelper.toLight((lampsArray = pLamp.fetchData(dataRepository.getInputStream())).get(0), dataRepository);
                        if (light != null) {
                            light.setName(name);
                        }
                        if (light instanceof PointLight) {
                            ((PointLight)light).setPosition(t.getTranslation());
                        } else if (light instanceof DirectionalLight) {
                            quaternion = t.getRotation();
                            axes = new Vector3f[3];
                            quaternion.toAxes(axes);
                            ((DirectionalLight)light).setDirection(axes[2].negate());
                        } else if (light instanceof SpotLight) {
                            ((SpotLight)light).setPosition(t.getTranslation());
                            quaternion = t.getRotation();
                            axes = new Vector3f[3];
                            quaternion.toAxes(axes);
                            ((SpotLight)light).setDirection(axes[2].negate());
                        } else {
                            ObjectHelper.LOGGER.log(Level.WARNING, "Unknown type of light: {0}", light);
                        }
                        result = light;
                        ** break;
                    }
lbl100:
                    // 3 sources

                    break;
                }
                case 11: {
                    pCamera = (Pointer)objectStructure.getFieldValue("data");
                    if (pCamera.isNotNull()) {
                        cameraHelper = (CameraHelper)dataRepository.getHelper(CameraHelper.class);
                        camerasArray = pCamera.fetchData(dataRepository.getInputStream());
                        camera = cameraHelper.toCamera(camerasArray.get(0));
                        camera.setLocation(t.getTranslation());
                        camera.setRotation(t.getRotation());
                        result = camera;
                        ** break;
                    }
lbl111:
                    // 3 sources

                    break;
                }
                case 25: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing armature.");
                    pArmature = (Pointer)objectStructure.getFieldValue("data");
                    armaturesArray = pArmature.fetchData(dataRepository.getInputStream());
                    result = armatureHelper.toArmature(armaturesArray.get(0), dataRepository);
                    ** break;
lbl118:
                    // 1 sources

                    break;
                }
                default: {
                    ObjectHelper.LOGGER.log(Level.WARNING, "Unknown object type: {0}", type);
                    break;
                }
            }
        }
        finally {
            dataRepository.popParent();
        }
        properties = this.loadProperties(objectStructure, dataRepository);
        if (result instanceof Spatial && properties != null && properties.getValue() != null) {
            ((Spatial)result).setUserData("properties", properties);
        }
        if (result != null) {
            dataRepository.addLoadedFeatures(objectStructure.getOldMemoryAddress(), name, objectStructure, result);
        }
        return result;
    }

    public Transform getTransformation(Structure objectStructure, DataRepository dataRepository) {
        DynamicArray loc = (DynamicArray)objectStructure.getFieldValue("loc");
        DynamicArray size = (DynamicArray)objectStructure.getFieldValue("size");
        DynamicArray rot = (DynamicArray)objectStructure.getFieldValue("rot");
        Pointer pParent = (Pointer)objectStructure.getFieldValue("parent");
        Structure parent = null;
        if (pParent.isNotNull()) {
            try {
                parent = pParent.fetchData(dataRepository.getInputStream()).get(0);
            }
            catch (BlenderFileException e) {
                LOGGER.log(Level.WARNING, "Cannot fetch parent for object! Reason: {0}", e.getLocalizedMessage());
            }
        }
        Matrix4f parentInv = pParent.isNull() ? Matrix4f.IDENTITY : this.getMatrix(objectStructure, "parentinv");
        Matrix4f globalMatrix = new Matrix4f();
        globalMatrix.setTranslation(((Number)loc.get(0)).floatValue(), ((Number)loc.get(1)).floatValue(), ((Number)loc.get(2)).floatValue());
        globalMatrix.setRotationQuaternion(new Quaternion().fromAngles(((Number)rot.get(0)).floatValue(), ((Number)rot.get(1)).floatValue(), ((Number)rot.get(2)).floatValue()));
        Matrix4f localMatrix = parentInv.mult(globalMatrix);
        Vector3f translation = localMatrix.toTranslationVector();
        Quaternion rotation = localMatrix.toRotationQuat();
        float scaleX = (float)Math.sqrt(parentInv.m00 * parentInv.m00 + parentInv.m10 * parentInv.m10 + parentInv.m20 * parentInv.m20);
        float scaleY = (float)Math.sqrt(parentInv.m01 * parentInv.m01 + parentInv.m11 * parentInv.m11 + parentInv.m21 * parentInv.m21);
        float scaleZ = (float)Math.sqrt(parentInv.m02 * parentInv.m02 + parentInv.m12 * parentInv.m12 + parentInv.m22 * parentInv.m22);
        Vector3f scale = new Vector3f(((Number)size.get(0)).floatValue() * scaleX, ((Number)size.get(1)).floatValue() * scaleY, ((Number)size.get(2)).floatValue() * scaleZ);
        if (this.fixUpAxis && (pParent.isNull() || parent != null && !this.shouldBeLoaded(parent, dataRepository))) {
            float y = translation.y;
            translation.y = translation.z;
            translation.z = -y;
            rotation = this.upAxisRotationQuaternion.mult(rotation);
        }
        Transform t = new Transform(translation, rotation);
        t.setScale(scale);
        return t;
    }

    public Matrix4f getTransformationMatrix(Structure objectStructure) {
        return this.getMatrix(objectStructure, "obmat");
    }

    protected Matrix4f getMatrix(Structure objectStructure, String matrixName) {
        Matrix4f result = new Matrix4f();
        DynamicArray obmat = (DynamicArray)objectStructure.getFieldValue(matrixName);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                result.set(i, j, ((Number)obmat.get(j, i)).floatValue());
            }
        }
        return result;
    }

    public void clearState() {
        this.fixUpAxis = false;
    }

    public boolean shouldBeLoaded(Structure structure, DataRepository dataRepository) {
        int lay = ((Number)structure.getFieldValue("lay")).intValue();
        return (lay & dataRepository.getBlenderKey().getLayersToLoad()) != 0 && (dataRepository.getBlenderKey().getFeaturesToLoad() & 0xB) != 0;
    }

    static {
        invisibleTypes.add(0);
        invisibleTypes.add(25);
    }
}

