/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.scene.Mesh;
import com.jme3.shader.Shader;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import java.util.HashSet;

public class Statistics {
    protected int numObjects;
    protected int numTriangles;
    protected int numVertices;
    protected int numShaderSwitches;
    protected int numTextureBinds;
    protected int numFboSwitches;
    protected int numUniformsSet;
    protected int memoryShaders;
    protected int memoryFrameBuffers;
    protected int memoryTextures;
    protected HashSet<Integer> shadersUsed = new HashSet();
    protected HashSet<Integer> texturesUsed = new HashSet();
    protected HashSet<Integer> fbosUsed = new HashSet();

    public String[] getLabels() {
        return new String[]{"Vertices", "Triangles", "Uniforms", "Objects", "Shaders (S)", "Shaders (F)", "Shaders (M)", "Textures (S)", "Textures (F)", "Textures (M)", "FrameBuffers (S)", "FrameBuffers (F)", "FrameBuffers (M)"};
    }

    public void getData(int[] data) {
        data[0] = this.numVertices;
        data[1] = this.numTriangles;
        data[2] = this.numUniformsSet;
        data[3] = this.numObjects;
        data[4] = this.numShaderSwitches;
        data[5] = this.shadersUsed.size();
        data[6] = this.memoryShaders;
        data[7] = this.numTextureBinds;
        data[8] = this.texturesUsed.size();
        data[9] = this.memoryTextures;
        data[10] = this.numFboSwitches;
        data[11] = this.fbosUsed.size();
        data[12] = this.memoryFrameBuffers;
    }

    public void onMeshDrawn(Mesh mesh, int lod) {
        ++this.numObjects;
        this.numTriangles += mesh.getTriangleCount(lod);
        this.numVertices += mesh.getVertexCount();
    }

    public void onShaderUse(Shader shader, boolean wasSwitched) {
        assert (shader.id >= 1);
        if (wasSwitched) {
            ++this.numShaderSwitches;
        }
    }

    public void onUniformSet() {
        ++this.numUniformsSet;
    }

    public void onTextureUse(Image image, boolean wasSwitched) {
        assert (image.id >= 1);
        if (wasSwitched) {
            ++this.numTextureBinds;
        }
    }

    public void onFrameBufferUse(FrameBuffer fb, boolean wasSwitched) {
        if (fb != null) assert (fb.id >= 1);
        if (wasSwitched) {
            ++this.numFboSwitches;
        }
    }

    public void clearFrame() {
        this.shadersUsed.clear();
        this.texturesUsed.clear();
        this.fbosUsed.clear();
        this.numObjects = 0;
        this.numTriangles = 0;
        this.numVertices = 0;
        this.numShaderSwitches = 0;
        this.numTextureBinds = 0;
        this.numFboSwitches = 0;
        this.numUniformsSet = 0;
    }

    public void onNewShader() {
        ++this.memoryShaders;
    }

    public void onNewTexture() {
        ++this.memoryTextures;
    }

    public void onNewFrameBuffer() {
        ++this.memoryFrameBuffers;
    }

    public void onDeleteShader() {
        --this.memoryShaders;
    }

    public void onDeleteTexture() {
        --this.memoryTextures;
    }

    public void onDeleteFrameBuffer() {
        --this.memoryFrameBuffers;
    }

    public void clearMemory() {
        this.memoryFrameBuffers = 0;
        this.memoryShaders = 0;
        this.memoryTextures = 0;
    }
}

