/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.PMDSkinVertData;

public class PMDSkinData {
    private String skinName;
    private int skinVertCount;
    private int skinType;
    private PMDSkinVertData[] skinVertData;

    public PMDSkinData(DataInputStreamLittleEndian is) throws IOException {
        this.skinName = is.readString(20);
        this.skinVertCount = is.readInt();
        this.skinType = is.readByte();
        this.skinVertData = new PMDSkinVertData[this.skinVertCount];
        for (int i = 0; i < this.skinVertCount; ++i) {
            this.skinVertData[i] = new PMDSkinVertData(is);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{skinName = " + this.skinName + "\nskinVertCount = " + this.skinVertCount + "\nskinType = " + this.skinType + "\nskinVertData = ");
        for (int i = 0; i < this.skinVertCount; ++i) {
            sb.append(this.skinVertData[i]);
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setSkinType(int skinType) {
        this.skinType = skinType;
    }

    public int getSkinVertCount() {
        return this.skinVertCount;
    }

    public void setSkinVertCount(int skinVertCount) {
        this.skinVertCount = skinVertCount;
    }

    public PMDSkinVertData[] getSkinVertData() {
        return this.skinVertData;
    }

    public void setSkinVertData(PMDSkinVertData[] skinVertData) {
        this.skinVertData = skinVertData;
    }
}

